/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.claxon.exotic.jvm;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.smallmind.claxon.exotic.jvm.JVMState;
import org.smallmind.claxon.registry.Quantity;
import org.smallmind.claxon.registry.Tag;
import org.smallmind.claxon.registry.feature.Feature;

public class ProfileFeature
implements Feature {
    private final Tag[] tags;
    private final String name;
    private final Long minimumRecordingDelayMilliseconds;
    private long lastRecordingTimestamp = -1L;

    public ProfileFeature(String name, Long minimumRecordingDelayMilliseconds, boolean addHostNameTag, Tag ... tags) throws UnknownHostException {
        this.name = name;
        this.minimumRecordingDelayMilliseconds = minimumRecordingDelayMilliseconds;
        if (!addHostNameTag) {
            this.tags = tags;
        } else {
            InetAddress localHost = InetAddress.getLocalHost();
            String hostName = localHost.getHostName();
            if (tags == null || tags.length == 0) {
                this.tags = new Tag[]{new Tag("host", hostName)};
            } else {
                this.tags = new Tag[tags.length + 1];
                this.tags[0] = new Tag("host", hostName);
                System.arraycopy(tags, 0, this.tags, 1, tags.length);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public Tag[] getTags() {
        return this.tags;
    }

    public Quantity[] record() {
        long now = System.currentTimeMillis();
        if (this.minimumRecordingDelayMilliseconds != null && this.lastRecordingTimestamp >= 0L && this.minimumRecordingDelayMilliseconds > now - this.lastRecordingTimestamp) {
            return null;
        }
        this.lastRecordingTimestamp = now;
        Quantity[] quantityArray = new Quantity[15];
        long totalMemorySize = JVMState.getTotalMemorySize();
        quantityArray[0] = new Quantity("totalMemorySize", (double)totalMemorySize);
        long freeMemorySize = JVMState.getFreeMemorySize();
        quantityArray[1] = new Quantity("freeMemorySize", (double)freeMemorySize);
        quantityArray[2] = new Quantity("userMemoryPercent", (double)(totalMemorySize - freeMemorySize) * 100.0 / (double)totalMemorySize);
        quantityArray[3] = new Quantity("heapMemoryMax", (double)JVMState.getHeapMemoryMax());
        long heapMemoryMax = JVMState.getHeapMemoryUsed();
        quantityArray[4] = new Quantity("heapMemoryUsed", (double)heapMemoryMax);
        quantityArray[5] = new Quantity("processCPUTime", (double)JVMState.getProcessCPUTime());
        quantityArray[6] = new Quantity("compilationTime", (double)JVMState.getCompilationTime());
        quantityArray[7] = new Quantity("youngGenerationHeapSize", (double)(heapMemoryMax - JVMState.getTenuredMemoryMax()));
        quantityArray[8] = new Quantity("youngCollectionCount", (double)JVMState.getYoungCollectionCount());
        quantityArray[9] = new Quantity("youngCollectionTime", (double)JVMState.getYoungCollectionTime());
        quantityArray[10] = new Quantity("oldCollectionCount", (double)JVMState.getOldCollectionCount());
        quantityArray[11] = new Quantity("oldCollectionTime", (double)JVMState.getOldCollectionTime());
        quantityArray[12] = new Quantity("edenMemoryUsed", (double)JVMState.getCompilationTime());
        quantityArray[13] = new Quantity("survivorMemoryUsed", (double)JVMState.getCompilationTime());
        quantityArray[14] = new Quantity("tenuredMemoryUsed", (double)JVMState.getCompilationTime());
        return quantityArray;
    }
}

