/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.claxon.exotic.jvm;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.List;

public class GarbageFacts {
    private final GarbageStatistics youngGarbageStatistics;
    private final GarbageStatistics oldGarbageStatistics;

    public GarbageFacts() {
        List<GarbageCollectorMXBean> garbageCollectorMXBeans = ManagementFactory.getGarbageCollectorMXBeans();
        GarbageCollectorMXBean youngGarbageCollectorMXBean = null;
        GarbageCollectorMXBean oldGarbageCollectorMXBean = null;
        for (GarbageCollectorMXBean garbageCollectorMXBean : garbageCollectorMXBeans) {
            switch (garbageCollectorMXBean.getName()) {
                case "ParNew": 
                case "Shenandoah Pauses": 
                case "PS Scavenge": 
                case "G1 Young Generation": {
                    youngGarbageCollectorMXBean = garbageCollectorMXBean;
                    break;
                }
                case "Shenandoah Cycles": 
                case "ConcurrentMarkSweep": 
                case "ZGC": 
                case "G1 Old Generation": 
                case "PS MarkSweep": {
                    oldGarbageCollectorMXBean = garbageCollectorMXBean;
                }
            }
        }
        this.youngGarbageStatistics = youngGarbageCollectorMXBean == null ? GarbageStatistics.NO_GARBAGE_STATISTICS : GarbageStatistics.from(youngGarbageCollectorMXBean);
        this.oldGarbageStatistics = oldGarbageCollectorMXBean == null ? GarbageStatistics.NO_GARBAGE_STATISTICS : GarbageStatistics.from(oldGarbageCollectorMXBean);
    }

    public long getYoungCollectionTime() {
        return this.youngGarbageStatistics.getCollectionTime();
    }

    public long getYoungCollectionCount() {
        return this.youngGarbageStatistics.getCollectionCount();
    }

    public long getOldCollectionTime() {
        return this.oldGarbageStatistics.getCollectionTime();
    }

    public long getOldCollectionCount() {
        return this.oldGarbageStatistics.getCollectionCount();
    }

    private static interface GarbageStatistics {
        public static final GarbageStatistics NO_GARBAGE_STATISTICS = new GarbageStatistics(){};

        public static GarbageStatistics from(final GarbageCollectorMXBean mxBean) {
            return new GarbageStatistics(){

                @Override
                public long getCollectionCount() {
                    return mxBean.getCollectionCount();
                }

                @Override
                public long getCollectionTime() {
                    return mxBean.getCollectionTime();
                }
            };
        }

        default public long getCollectionCount() {
            return 0L;
        }

        default public long getCollectionTime() {
            return 0L;
        }
    }
}

