/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.claxon.exotic.jvm;

import org.smallmind.claxon.exotic.jvm.CompilationAndHeapFacts;
import org.smallmind.claxon.exotic.jvm.GarbageFacts;
import org.smallmind.claxon.exotic.jvm.MemoryPools;
import org.smallmind.claxon.exotic.jvm.OSFacts;

public class JVMState {
    private static final MemoryPools MEMORY_POOLS = new MemoryPools();
    private static final OSFacts OS_FACTS = new OSFacts();
    private static final GarbageFacts GARBAGE_FACTS = new GarbageFacts();
    private static final CompilationAndHeapFacts COMPILATION_AND_HEAP_FACTS = new CompilationAndHeapFacts();

    public static long getTotalMemorySize() {
        return OS_FACTS.getTotalMemorySize();
    }

    public static long getFreeMemorySize() {
        return OS_FACTS.getFreeMemorySize();
    }

    public static long getHeapMemoryMax() {
        return COMPILATION_AND_HEAP_FACTS.getHeapMemoryUsage().getMax();
    }

    public static long getHeapMemoryUsed() {
        return COMPILATION_AND_HEAP_FACTS.getHeapMemoryUsage().getUsed();
    }

    public static long getProcessCPUTime() {
        return OS_FACTS.getProcessCpuTime();
    }

    public static long getCompilationTime() {
        return COMPILATION_AND_HEAP_FACTS.getCompilationTime();
    }

    public static long getYoungCollectionCount() {
        return GARBAGE_FACTS.getYoungCollectionCount();
    }

    public static long getYoungCollectionTime() {
        return GARBAGE_FACTS.getYoungCollectionTime();
    }

    public static long getOldCollectionCount() {
        return GARBAGE_FACTS.getOldCollectionCount();
    }

    public static long getOldCollectionTime() {
        return GARBAGE_FACTS.getOldCollectionTime();
    }

    public static long getEdenMemoryUsed() {
        return MEMORY_POOLS.getEdenMemoryUsage().getUsed();
    }

    public static long getSurvivorMemoryUsed() {
        return MEMORY_POOLS.getSurvivorMemoryUsage().getUsed();
    }

    public static long getTenuredMemoryMax() {
        return MEMORY_POOLS.getTenuredMemoryUsage().getMax();
    }

    public static long getTenuredMemoryUsed() {
        return MEMORY_POOLS.getTenuredMemoryUsage().getUsed();
    }
}

