/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.file.jailed;

import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.WatchService;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.spi.FileSystemProvider;
import java.util.List;
import java.util.Set;
import org.smallmind.file.jailed.JailedFileSystemProvider;
import org.smallmind.file.jailed.JailedPath;

public class JailedFileSystem
extends FileSystem {
    private static final String SEPARATOR = Character.toString('/');
    private final JailedFileSystemProvider jailedFileSystemProvider;
    private final JailedPath rootPath;

    public JailedFileSystem(JailedFileSystemProvider jailedFileSystemProvider) {
        this.jailedFileSystemProvider = jailedFileSystemProvider;
        this.rootPath = new JailedPath(this, this.getSeparator().toCharArray(), true, new JailedPath.Segment[0]);
    }

    @Override
    public FileSystemProvider provider() {
        return this.jailedFileSystemProvider;
    }

    @Override
    public void close() {
    }

    @Override
    public boolean isOpen() {
        return this.jailedFileSystemProvider.getJailedPathTranslator().getNativeFileSystem().isOpen();
    }

    @Override
    public boolean isReadOnly() {
        return this.jailedFileSystemProvider.getJailedPathTranslator().getNativeFileSystem().isReadOnly();
    }

    @Override
    public String getSeparator() {
        return SEPARATOR;
    }

    @Override
    public Iterable<Path> getRootDirectories() {
        return List.of(this.rootPath);
    }

    @Override
    public Iterable<FileStore> getFileStores() {
        return this.jailedFileSystemProvider.getJailedPathTranslator().getNativeFileSystem().getFileStores();
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        return this.jailedFileSystemProvider.getJailedPathTranslator().getNativeFileSystem().supportedFileAttributeViews();
    }

    @Override
    public Path getPath(String first, String ... more) {
        return new JailedPath(this, (String)(more == null || more.length == 0 ? first : first + this.getSeparator() + String.join((CharSequence)this.getSeparator(), more)));
    }

    @Override
    public PathMatcher getPathMatcher(String syntaxAndPattern) {
        return this.jailedFileSystemProvider.getJailedPathTranslator().getNativeFileSystem().getPathMatcher(syntaxAndPattern);
    }

    @Override
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        return this.jailedFileSystemProvider.getJailedPathTranslator().getNativeFileSystem().getUserPrincipalLookupService();
    }

    @Override
    public WatchService newWatchService() throws IOException {
        return this.jailedFileSystemProvider.getJailedPathTranslator().getNativeFileSystem().newWatchService();
    }
}

