/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.file.jailed;

import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import org.smallmind.file.jailed.JailedFileSystem;
import org.smallmind.file.jailed.JailedPath;
import org.smallmind.file.jailed.JailedPathTranslator;
import org.smallmind.file.jailed.RootedFileSystemContext;
import org.smallmind.nutsnbolts.context.ContextFactory;

public class ContextSensitiveRootedPathTranslator
implements JailedPathTranslator {
    private final FileSystem nativeFileSystem;

    public ContextSensitiveRootedPathTranslator(FileSystem nativeFileSystem) {
        this.nativeFileSystem = nativeFileSystem;
    }

    @Override
    public FileSystem getNativeFileSystem() {
        return this.nativeFileSystem;
    }

    @Override
    public Path wrapPath(JailedFileSystem jailedFileSystem, Path nativePath) {
        String root;
        RootedFileSystemContext rootedFileSystemContext = (RootedFileSystemContext)ContextFactory.getContext(RootedFileSystemContext.class);
        if (rootedFileSystemContext == null || (root = rootedFileSystemContext.getRoot()) == null) {
            throw new SecurityException("No authorization for path");
        }
        Path rootPath = FileSystems.getDefault().getPath(root, new String[0]);
        if (nativePath.isAbsolute()) {
            if (!nativePath.startsWith(rootPath)) {
                throw new SecurityException("No authorization for path");
            }
            StringBuilder pathBuilder = new StringBuilder();
            for (int index = rootPath.getNameCount(); index < nativePath.getNameCount(); ++index) {
                pathBuilder.append(jailedFileSystem.getSeparator()).append(nativePath.getName(index));
            }
            return new JailedPath(jailedFileSystem, pathBuilder.toString());
        }
        StringBuilder pathBuilder = new StringBuilder();
        for (int index = 0; index < nativePath.getNameCount(); ++index) {
            pathBuilder.append('/').append(nativePath.getName(index));
        }
        return new JailedPath(jailedFileSystem, pathBuilder.toString());
    }

    @Override
    public Path unwrapPath(Path jailedPath) {
        String root;
        RootedFileSystemContext rootedFileSystemContext = (RootedFileSystemContext)ContextFactory.getContext(RootedFileSystemContext.class);
        if (rootedFileSystemContext == null || (root = rootedFileSystemContext.getRoot()) == null) {
            throw new SecurityException("No authorization for path");
        }
        Path rootPath = FileSystems.getDefault().getPath(root, new String[0]);
        StringBuilder pathBuilder = new StringBuilder();
        for (int index = 0; index < jailedPath.getNameCount(); ++index) {
            if (index > 0) {
                pathBuilder.append(this.getNativeFileSystem().getSeparator());
            }
            pathBuilder.append(jailedPath.getName(index));
        }
        return rootPath.resolve(pathBuilder.toString());
    }
}

