/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.file.jailed;

import java.nio.file.FileSystem;
import java.nio.file.Path;
import org.smallmind.file.jailed.JailedFileSystem;
import org.smallmind.file.jailed.JailedPath;
import org.smallmind.file.jailed.JailedPathTranslator;

public class RootedPathTranslator
implements JailedPathTranslator {
    private final Path rootPath;

    public RootedPathTranslator(Path rootPath) {
        this.rootPath = rootPath;
    }

    @Override
    public FileSystem getNativeFileSystem() {
        return this.rootPath.getFileSystem();
    }

    @Override
    public Path wrapPath(JailedFileSystem jailedFileSystem, Path nativePath) {
        if (nativePath.isAbsolute()) {
            if (!nativePath.startsWith(this.rootPath)) {
                throw new SecurityException("No authorization for path");
            }
            StringBuilder pathBuilder = new StringBuilder();
            for (int index = this.rootPath.getNameCount(); index < nativePath.getNameCount(); ++index) {
                pathBuilder.append(jailedFileSystem.getSeparator()).append(nativePath.getName(index));
            }
            return new JailedPath(jailedFileSystem, pathBuilder.toString());
        }
        StringBuilder pathBuilder = new StringBuilder();
        for (int index = 0; index < nativePath.getNameCount(); ++index) {
            pathBuilder.append('/').append(nativePath.getName(index));
        }
        return new JailedPath(jailedFileSystem, pathBuilder.toString());
    }

    @Override
    public Path unwrapPath(Path jailedPath) {
        StringBuilder pathBuilder = new StringBuilder();
        for (int index = 0; index < jailedPath.getNameCount(); ++index) {
            if (index > 0) {
                pathBuilder.append(this.getNativeFileSystem().getSeparator());
            }
            pathBuilder.append(jailedPath.getName(index));
        }
        return this.rootPath.resolve(pathBuilder.toString());
    }
}

