/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.file.jailed;

import java.io.IOException;
import java.net.URI;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.spi.FileSystemProvider;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.smallmind.file.jailed.ContextSensitiveRootedPathTranslator;
import org.smallmind.file.jailed.JailedFileSystem;
import org.smallmind.file.jailed.JailedPathTranslator;
import org.smallmind.file.jailed.JailedURIUtility;

public class JailedFileSystemProvider
extends FileSystemProvider {
    private final JailedFileSystem jailedFileSystem;
    private final JailedPathTranslator jailedPathTranslator;
    private final String scheme;

    public JailedFileSystemProvider() {
        this("jailed", new ContextSensitiveRootedPathTranslator(FileSystems.getDefault()));
    }

    public JailedFileSystemProvider(FileSystemProvider fileSystemProvider) {
        this("jailed", new ContextSensitiveRootedPathTranslator(fileSystemProvider.getFileSystem(URI.create(fileSystemProvider.getScheme() + ":///"))));
    }

    public JailedFileSystemProvider(String scheme, JailedPathTranslator jailedPathTranslator) {
        this.scheme = scheme;
        this.jailedPathTranslator = jailedPathTranslator;
        this.jailedFileSystem = new JailedFileSystem(this);
    }

    @Override
    public String getScheme() {
        return this.scheme;
    }

    public JailedPathTranslator getJailedPathTranslator() {
        return this.jailedPathTranslator;
    }

    @Override
    public FileSystem newFileSystem(URI uri, Map<String, ?> env) {
        JailedURIUtility.checkUri(this.scheme, uri);
        throw new FileSystemAlreadyExistsException();
    }

    @Override
    public FileSystem getFileSystem(URI uri) {
        JailedURIUtility.checkUri(this.scheme, uri);
        return this.jailedFileSystem;
    }

    @Override
    public Path getPath(URI uri) {
        return JailedURIUtility.fromUri(this.jailedFileSystem, uri);
    }

    @Override
    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        return this.jailedPathTranslator.getNativeFileSystem().provider().newByteChannel(this.jailedPathTranslator.unwrapPath(path), options, attrs);
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
        final DirectoryStream<Path> nativeDirectoryStream = this.jailedPathTranslator.getNativeFileSystem().provider().newDirectoryStream(this.jailedPathTranslator.unwrapPath(dir), entry -> {
            try {
                return filter.accept(this.jailedPathTranslator.wrapPath(this.jailedFileSystem, (Path)entry));
            }
            catch (IOException ioException) {
                throw new RuntimeException(ioException);
            }
        });
        return new DirectoryStream<Path>(){

            @Override
            public Iterator<Path> iterator() {
                final Iterator nativeIterator = nativeDirectoryStream.iterator();
                return new Iterator<Path>(){

                    @Override
                    public boolean hasNext() {
                        return nativeIterator.hasNext();
                    }

                    @Override
                    public Path next() {
                        try {
                            return JailedFileSystemProvider.this.jailedPathTranslator.wrapPath(JailedFileSystemProvider.this.jailedFileSystem, (Path)nativeIterator.next());
                        }
                        catch (IOException ioException) {
                            throw new RuntimeException(ioException);
                        }
                    }
                };
            }

            @Override
            public void close() throws IOException {
                nativeDirectoryStream.close();
            }
        };
    }

    @Override
    public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
        this.jailedPathTranslator.getNativeFileSystem().provider().createDirectory(this.jailedPathTranslator.unwrapPath(dir), attrs);
    }

    @Override
    public void delete(Path path) throws IOException {
        this.jailedPathTranslator.getNativeFileSystem().provider().delete(this.jailedPathTranslator.unwrapPath(path));
    }

    @Override
    public void copy(Path source, Path target, CopyOption ... options) throws IOException {
        this.jailedPathTranslator.getNativeFileSystem().provider().copy(this.jailedPathTranslator.unwrapPath(source), this.jailedPathTranslator.unwrapPath(target), options);
    }

    @Override
    public void move(Path source, Path target, CopyOption ... options) throws IOException {
        this.jailedPathTranslator.getNativeFileSystem().provider().move(this.jailedPathTranslator.unwrapPath(source), this.jailedPathTranslator.unwrapPath(target), options);
    }

    @Override
    public boolean isSameFile(Path path, Path path2) throws IOException {
        return this.jailedPathTranslator.getNativeFileSystem().provider().isSameFile(this.jailedPathTranslator.unwrapPath(path), this.jailedPathTranslator.unwrapPath(path));
    }

    @Override
    public boolean isHidden(Path path) throws IOException {
        return this.jailedPathTranslator.getNativeFileSystem().provider().isHidden(this.jailedPathTranslator.unwrapPath(path));
    }

    @Override
    public FileStore getFileStore(Path path) throws IOException {
        return this.jailedPathTranslator.getNativeFileSystem().provider().getFileStore(this.jailedPathTranslator.unwrapPath(path));
    }

    @Override
    public void checkAccess(Path path, AccessMode ... modes) throws IOException {
        this.jailedPathTranslator.getNativeFileSystem().provider().checkAccess(this.jailedPathTranslator.unwrapPath(path), modes);
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type, LinkOption ... options) {
        try {
            return this.jailedPathTranslator.getNativeFileSystem().provider().getFileAttributeView(this.jailedPathTranslator.unwrapPath(path), type, options);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    @Override
    public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... options) throws IOException {
        return this.jailedPathTranslator.getNativeFileSystem().provider().readAttributes(this.jailedPathTranslator.unwrapPath(path), type, options);
    }

    @Override
    public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
        return this.jailedPathTranslator.getNativeFileSystem().provider().readAttributes(this.jailedPathTranslator.unwrapPath(path), attributes, options);
    }

    @Override
    public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws IOException {
        this.jailedPathTranslator.getNativeFileSystem().provider().setAttribute(this.jailedPathTranslator.unwrapPath(path), attribute, value, options);
    }
}

