/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.file.jailed;

import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import org.smallmind.file.jailed.AbstractJailedPathTranslator;
import org.smallmind.file.jailed.JailedFileSystem;
import org.smallmind.file.jailed.RootedFileSystemContext;
import org.smallmind.nutsnbolts.context.ContextFactory;

public class ContextSensitiveRootedPathTranslator
extends AbstractJailedPathTranslator {
    private final FileSystem nativeFileSystem;

    public ContextSensitiveRootedPathTranslator(FileSystem nativeFileSystem) {
        this.nativeFileSystem = nativeFileSystem;
    }

    @Override
    public FileSystem getNativeFileSystem() {
        return this.nativeFileSystem;
    }

    @Override
    public Path wrapPath(JailedFileSystem jailedFileSystem, Path nativePath) {
        String root;
        RootedFileSystemContext rootedFileSystemContext = (RootedFileSystemContext)ContextFactory.getContext(RootedFileSystemContext.class);
        if (rootedFileSystemContext == null || (root = rootedFileSystemContext.getRoot()) == null) {
            throw new SecurityException("No authorization for path");
        }
        return this.wrapPath(FileSystems.getDefault().getPath(root, new String[0]), jailedFileSystem, nativePath);
    }

    @Override
    public Path unwrapPath(Path jailedPath) {
        String root;
        RootedFileSystemContext rootedFileSystemContext = (RootedFileSystemContext)ContextFactory.getContext(RootedFileSystemContext.class);
        if (rootedFileSystemContext == null || (root = rootedFileSystemContext.getRoot()) == null) {
            throw new SecurityException("No authorization for path");
        }
        return this.unwrapPath(FileSystems.getDefault().getPath(root, new String[0]), jailedPath);
    }
}

