/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.file.jailed;

import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Arrays;
import java.util.LinkedList;
import org.smallmind.file.jailed.JailedFileSystem;

public class JailedPath
implements Path {
    protected static final char SEPARATOR = '/';
    private final JailedFileSystem jailedFileSystem;
    private final Segment[] segments;
    private final char[] text;
    private final boolean hasRoot;

    protected JailedPath(JailedFileSystem jailedFileSystem, char[] text, boolean hasRoot, Segment ... segments) {
        this.jailedFileSystem = jailedFileSystem;
        this.text = text;
        this.hasRoot = hasRoot;
        this.segments = segments;
    }

    public JailedPath(JailedFileSystem jailedFileSystem, char ... text) {
        this.jailedFileSystem = jailedFileSystem;
        this.text = text;
        this.hasRoot = text.length > 0 && text[0] == '/';
        this.segments = this.divideAndConquer();
    }

    public JailedPath(JailedFileSystem jailedFileSystem, String text) {
        this(jailedFileSystem, text.toCharArray());
    }

    private Segment[] divideAndConquer() {
        boolean slash = true;
        int count = 0;
        int begin = 0;
        for (char singleChar : this.text) {
            if (singleChar == '/') {
                slash = true;
                continue;
            }
            if (!slash) continue;
            slash = false;
            ++count;
        }
        Segment[] segments = new Segment[count];
        if (count > 0) {
            slash = true;
            count = 0;
            for (int index = 0; index < this.text.length; ++index) {
                if (this.text[index] == '/') {
                    if (!slash) {
                        segments[count++] = new Segment(begin, index);
                    }
                    slash = true;
                    continue;
                }
                if (!slash) continue;
                slash = false;
                begin = index;
            }
            if (!slash) {
                segments[count] = new Segment(begin, this.text.length);
            }
        }
        return segments;
    }

    private char[] getText() {
        return this.text;
    }

    private Segment[] getSegments() {
        return this.segments;
    }

    private boolean sameSegment(char[] otherText, Segment otherSegment, int segmentIndex) {
        Segment segment = this.segments[segmentIndex];
        int segmentLength = segment.length();
        if (segmentLength == otherSegment.length()) {
            for (int charIndex = 0; charIndex < segmentLength; ++charIndex) {
                if (this.text[segment.getBegin() + charIndex] == otherText[otherSegment.getBegin() + charIndex]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private Path constructPath(char[] text, boolean hasRoot, Segment ... segments) {
        return this.constructPath(null, null, text, hasRoot, segments);
    }

    private Path constructPath(char[] prologueText, Segment[] prologueSegments, char[] text, boolean hasRoot, Segment ... segments) {
        StringBuilder translatedTextBuilder;
        int prologueSegmentCount = prologueSegments == null ? 0 : prologueSegments.length;
        Segment[] translatedSegments = new Segment[prologueSegmentCount + segments.length];
        StringBuilder stringBuilder = translatedTextBuilder = prologueText == null ? new StringBuilder() : new StringBuilder(String.copyValueOf(prologueText));
        if (prologueSegments != null) {
            System.arraycopy(prologueSegments, 0, translatedSegments, 0, prologueSegments.length);
        }
        for (int segmentIndex = 0; segmentIndex < segments.length; ++segmentIndex) {
            int segmentLength = segments[segmentIndex].length();
            if (hasRoot || translatedTextBuilder.length() > 0) {
                translatedTextBuilder.append('/');
                translatedSegments[prologueSegmentCount + segmentIndex] = new Segment(translatedTextBuilder.length(), translatedTextBuilder.length() + segmentLength);
            } else {
                translatedSegments[prologueSegmentCount + segmentIndex] = new Segment(0, segmentLength);
            }
            for (int charIndex = 0; charIndex < segmentLength; ++charIndex) {
                translatedTextBuilder.append(text[segments[segmentIndex].getBegin() + charIndex]);
            }
        }
        char[] translatedText = new char[translatedTextBuilder.length()];
        translatedTextBuilder.getChars(0, translatedTextBuilder.length(), translatedText, 0);
        return new JailedPath(this.jailedFileSystem, translatedText, hasRoot, translatedSegments);
    }

    @Override
    public FileSystem getFileSystem() {
        return this.jailedFileSystem;
    }

    @Override
    public boolean isAbsolute() {
        return this.hasRoot;
    }

    @Override
    public Path getRoot() {
        return this.hasRoot ? new JailedPath(this.jailedFileSystem, new char[]{'/'}, true, new Segment[0]) : null;
    }

    @Override
    public Path getFileName() {
        return this.segments.length == 0 ? null : this.constructPath(this.text, false, this.segments[this.segments.length - 1]);
    }

    @Override
    public Path getParent() {
        if (this.segments.length == 0) {
            return null;
        }
        if (this.segments.length == 1) {
            return this.getRoot();
        }
        Segment[] allButOne = new Segment[this.segments.length - 1];
        System.arraycopy(this.segments, 0, allButOne, 0, this.segments.length - 1);
        return this.constructPath(this.text, this.hasRoot, allButOne);
    }

    @Override
    public int getNameCount() {
        return this.segments.length;
    }

    @Override
    public Path getName(int index) {
        if (index < 0 || index >= this.segments.length) {
            throw new IllegalArgumentException("The requested element does not exist");
        }
        return this.constructPath(this.text, false, this.segments[index]);
    }

    @Override
    public Path subpath(int beginIndex, int endIndex) {
        if (beginIndex < 0 || beginIndex >= this.segments.length || endIndex <= beginIndex || endIndex > this.segments.length) {
            throw new IllegalArgumentException("The subpath specified does not exist");
        }
        Segment[] subSegments = new Segment[endIndex - beginIndex];
        System.arraycopy(this.segments, beginIndex, subSegments, 0, endIndex - beginIndex);
        return this.constructPath(this.text, false, subSegments);
    }

    @Override
    public boolean startsWith(Path other) {
        if (!(other instanceof JailedPath)) {
            throw new ProviderMismatchException();
        }
        if (this.hasRoot == other.isAbsolute() && other.getNameCount() <= this.segments.length) {
            int segmentIndex = 0;
            for (Segment otherSegment : ((JailedPath)other).getSegments()) {
                if (this.sameSegment(((JailedPath)other).getText(), otherSegment, segmentIndex++)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean endsWith(Path other) {
        if (!(other instanceof JailedPath)) {
            throw new ProviderMismatchException();
        }
        if ((!other.isAbsolute() || this.hasRoot) && this.segments.length >= other.getNameCount()) {
            int segmentIndex = this.segments.length - other.getNameCount();
            for (Segment otherSegment : ((JailedPath)other).getSegments()) {
                if (this.sameSegment(((JailedPath)other).getText(), otherSegment, segmentIndex++)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public Path normalize() {
        boolean normalized = true;
        for (Segment segment : this.segments) {
            int segmentLength = segment.length();
            if ((segmentLength != 1 || this.text[segment.getBegin()] != '.') && (segmentLength != 2 || this.text[segment.getBegin()] != '.' || this.text[segment.getBegin() + 1] != '.')) continue;
            normalized = false;
            break;
        }
        if (normalized) {
            return this;
        }
        LinkedList<Segment> normalizedSegmentList = new LinkedList<Segment>();
        for (Segment segment : this.segments) {
            int segmentLength = segment.length();
            if (segmentLength == 1 && this.text[segment.getBegin()] == '.') continue;
            if (segmentLength == 2 && this.text[segment.getBegin()] == '.' && this.text[segment.getBegin() + 1] == '.') {
                normalizedSegmentList.removeLast();
                continue;
            }
            normalizedSegmentList.add(segment);
        }
        return this.constructPath(this.text, this.hasRoot, normalizedSegmentList.toArray(new Segment[0]));
    }

    @Override
    public Path resolve(Path other) {
        if (!(other instanceof JailedPath)) {
            throw new ProviderMismatchException();
        }
        if (other.isAbsolute()) {
            return other;
        }
        if (other.getNameCount() == 0) {
            return this;
        }
        return this.constructPath(this.text, this.segments, ((JailedPath)other).getText(), this.hasRoot, ((JailedPath)other).getSegments());
    }

    @Override
    public Path relativize(Path other) {
        if (!(other instanceof JailedPath)) {
            throw new ProviderMismatchException();
        }
        if (this.hasRoot != other.isAbsolute()) {
            throw new IllegalArgumentException("The paths specified must be either both absolute or both relative");
        }
        JailedPath normalizedPath = (JailedPath)this.normalize();
        JailedPath otherNormalizedPath = (JailedPath)other.normalize();
        LinkedList<Segment> redactedSegmentList = new LinkedList<Segment>();
        StringBuilder redactedTextBuilder = new StringBuilder();
        for (int segmentIndex = 0; segmentIndex < this.segments.length; ++segmentIndex) {
            if (segmentIndex < otherNormalizedPath.getNameCount() && normalizedPath.sameSegment(otherNormalizedPath.getText(), otherNormalizedPath.getSegments()[segmentIndex], segmentIndex)) continue;
            for (int count = 0; count < this.segments.length - segmentIndex; ++count) {
                if (redactedTextBuilder.length() > 0) {
                    redactedSegmentList.add(new Segment(redactedTextBuilder.length() + 1, redactedTextBuilder.length() + 3));
                    redactedTextBuilder.append('/');
                } else {
                    redactedSegmentList.add(new Segment(0, 2));
                }
                redactedTextBuilder.append("..");
            }
            char[] redactedText = new char[redactedTextBuilder.length()];
            redactedTextBuilder.getChars(0, redactedTextBuilder.length(), redactedText, 0);
            return this.constructPath(redactedText, redactedSegmentList.toArray(new Segment[0]), otherNormalizedPath.getText(), false, Arrays.copyOfRange(otherNormalizedPath.getSegments(), segmentIndex, otherNormalizedPath.getNameCount()));
        }
        return this.constructPath(otherNormalizedPath.getText(), false, Arrays.copyOfRange(otherNormalizedPath.getSegments(), this.segments.length, otherNormalizedPath.getNameCount()));
    }

    @Override
    public Path toAbsolutePath() {
        if (this.isAbsolute()) {
            return this;
        }
        return this.constructPath(this.text, true, this.getSegments());
    }

    @Override
    public Path toRealPath(LinkOption ... options) {
        return this.normalize().toAbsolutePath();
    }

    @Override
    public int compareTo(Path other) {
        if (!(other instanceof JailedPath)) {
            throw new ProviderMismatchException();
        }
        if (this.hasRoot != other.isAbsolute()) {
            return this.hasRoot ? 1 : -1;
        }
        int maxSegmentCount = Math.max(this.segments.length, other.getNameCount());
        for (int segmentIndex = 0; segmentIndex < maxSegmentCount; ++segmentIndex) {
            if (segmentIndex >= this.segments.length || segmentIndex >= other.getNameCount()) {
                return segmentIndex >= this.segments.length ? -1 : 1;
            }
            int comparison = this.compareSegment(this.segments[segmentIndex], ((JailedPath)other).getText(), ((JailedPath)other).getSegments()[segmentIndex]);
            if (comparison == 0) continue;
            return comparison;
        }
        return 0;
    }

    private int compareSegment(Segment segment, char[] otherText, Segment otherSegment) {
        int segmentLength = segment.length();
        int otherSegmentLength = otherSegment.length();
        int maxSegmentLength = Math.max(segmentLength, otherSegmentLength);
        for (int charIndex = 0; charIndex < maxSegmentLength; ++charIndex) {
            if (charIndex >= segmentLength || charIndex >= otherSegmentLength) {
                return charIndex >= segmentLength ? -1 : 1;
            }
            int comparison = Character.compare(this.text[segment.getBegin() + charIndex], otherText[otherSegment.getBegin() + charIndex]);
            if (comparison == 0) continue;
            return comparison;
        }
        return 0;
    }

    @Override
    public URI toUri() {
        try {
            return new URI(this.jailedFileSystem.provider().getScheme(), "", this.toAbsolutePath().toString(), null);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        return String.valueOf(this.text);
    }

    protected static class Segment {
        private final int begin;
        private final int end;

        public Segment(int begin, int end) {
            this.begin = begin;
            this.end = end;
        }

        public int getBegin() {
            return this.begin;
        }

        public int getEnd() {
            return this.end;
        }

        public int length() {
            return this.end - this.begin;
        }
    }
}

