/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.file.jailed;

import java.net.URI;
import java.nio.file.Path;
import org.smallmind.file.jailed.JailedFileSystem;
import org.smallmind.file.jailed.JailedPath;

public class JailedURIUtility {
    public static void checkUri(String scheme, URI uri) {
        if (!uri.getScheme().equalsIgnoreCase(scheme)) {
            throw new IllegalArgumentException("URI does not match this provider");
        }
        if (uri.getAuthority() != null) {
            throw new IllegalArgumentException("URI has an authority component");
        }
        if (uri.getPath() == null) {
            throw new IllegalArgumentException("Path component is undefined");
        }
        if (!uri.getPath().equals("/")) {
            throw new IllegalArgumentException("Path component should be '/'");
        }
        if (uri.getQuery() != null) {
            throw new IllegalArgumentException("URI has a query component");
        }
        if (uri.getFragment() != null) {
            throw new IllegalArgumentException("URI has a fragment component");
        }
    }

    public static Path fromUri(JailedFileSystem jailedFileSystem, URI uri) {
        if (!uri.isAbsolute()) {
            throw new IllegalArgumentException("URI is not absolute");
        }
        if (uri.isOpaque()) {
            throw new IllegalArgumentException("URI is not hierarchical");
        }
        String scheme = uri.getScheme();
        if (scheme == null || !scheme.equalsIgnoreCase(jailedFileSystem.provider().getScheme())) {
            throw new IllegalArgumentException("URI does not match this provider");
        }
        if (uri.getAuthority() != null) {
            throw new IllegalArgumentException("URI has an authority component");
        }
        if (uri.getFragment() != null) {
            throw new IllegalArgumentException("URI has a fragment component");
        }
        if (uri.getQuery() != null) {
            throw new IllegalArgumentException("URI has a query component");
        }
        return new JailedPath(jailedFileSystem, uri.getPath());
    }
}

