/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.forge.style;

import org.smallmind.nutsnbolts.util.AlphaNumericComparator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DependencyWrapper
implements Comparable<DependencyWrapper> {
    private static final AlphaNumericComparator<String> ALPHA_NUMERIC_COMPARATOR = new AlphaNumericComparator();
    private final Node dependencyNode;
    private final String groupId;
    private final String artifactId;

    public DependencyWrapper(Node dependencyNode) {
        this.dependencyNode = dependencyNode;
        this.groupId = ((Element)dependencyNode).getElementsByTagName("groupId").item(0).getTextContent();
        this.artifactId = ((Element)dependencyNode).getElementsByTagName("artifactId").item(0).getTextContent();
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public Node getDependencyNode() {
        return this.dependencyNode;
    }

    @Override
    public int compareTo(DependencyWrapper otherWrapper) {
        int comparison = this.subCompare(this.groupId, otherWrapper.groupId, "\\.");
        if (comparison != 0) {
            return comparison;
        }
        return this.subCompare(this.artifactId, otherWrapper.artifactId, "-");
    }

    private int subCompare(String first, String second, String separator) {
        String[] firstSegements = first.split(separator);
        String[] secondSegments = second.split(separator);
        int comparableSegments = Math.min(firstSegements.length, secondSegments.length);
        for (int segmentIndex = 0; segmentIndex < comparableSegments; ++segmentIndex) {
            int comparison = ALPHA_NUMERIC_COMPARATOR.compare((Object)firstSegements[segmentIndex], (Object)secondSegments[segmentIndex]);
            if (comparison == 0) continue;
            return comparison;
        }
        return Integer.compare(firstSegements.length, secondSegments.length);
    }
}

