/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.forge.style;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.LinkedList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.smallmind.forge.style.DependencyWrapper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DependencyOrganizer {
    public static void main(String ... args) throws IOException {
        DependencyOrganizer.walkProject(Paths.get(args[0], new String[0]));
    }

    public static void walkProject(Path projectPath) throws IOException {
        Files.walkFileTree(projectPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                if ("pom.xml".equals(file.getFileName().toString())) {
                    try {
                        DependencyOrganizer.rewritePom(file);
                    }
                    catch (IOException | ParserConfigurationException | TransformerException | SAXException exception) {
                        throw new RuntimeException(exception);
                    }
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private static void rewritePom(Path pomPath) throws IOException, SAXException, ParserConfigurationException, TransformerException {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(Files.newInputStream(pomPath, new OpenOption[0]));
        NodeList projectNodeList = doc.getElementsByTagName("project");
        if (projectNodeList.getLength() > 0) {
            Node dependencyManagementNode;
            NodeList managedDependenciesNodeList;
            Node projectNode = projectNodeList.item(0);
            NodeList dependencyManagementNodelist = ((Element)projectNode).getElementsByTagName("dependencyManagement");
            NodeList dependenciesNodeList = ((Element)projectNode).getElementsByTagName("dependencies");
            if (dependencyManagementNodelist.getLength() > 0 && (managedDependenciesNodeList = ((Element)(dependencyManagementNode = dependencyManagementNodelist.item(0))).getElementsByTagName("dependencies")).getLength() > 0) {
                Node dependenciesNode = managedDependenciesNodeList.item(0);
                dependencyManagementNode.replaceChild(DependencyOrganizer.sortDependencies(dependenciesNode), dependenciesNode);
            }
            if (dependenciesNodeList.getLength() > 0) {
                for (int dependenciesIndex = 0; dependenciesIndex < dependenciesNodeList.getLength(); ++dependenciesIndex) {
                    Node dependenciesNode = dependenciesNodeList.item(dependenciesIndex);
                    if (!dependenciesNode.getParentNode().equals(projectNode)) continue;
                    projectNode.replaceChild(DependencyOrganizer.sortDependencies(dependenciesNode), dependenciesNode);
                    break;
                }
            }
        }
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer(new StreamSource(Thread.currentThread().getContextClassLoader().getResourceAsStream("org/smallmind/forge/style/pretty-print.xslt")));
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(Files.newOutputStream(pomPath, new OpenOption[0]));
        transformer.setOutputProperty("standalone", "no");
        transformer.transform(source, result);
    }

    private static Node sortDependencies(Node parentNode) {
        Node replacementParentNode = parentNode.cloneNode(false);
        NodeList dependencyNodeList = ((Element)parentNode).getElementsByTagName("dependency");
        LinkedList<DependencyWrapper> dependencyWrapperList = new LinkedList<DependencyWrapper>();
        if (dependencyNodeList.getLength() > 0) {
            for (int dependencyIndex = 0; dependencyIndex < dependencyNodeList.getLength(); ++dependencyIndex) {
                Node dependencyNode = dependencyNodeList.item(dependencyIndex);
                dependencyWrapperList.add(new DependencyWrapper(dependencyNode));
            }
            Collections.sort(dependencyWrapperList);
            for (DependencyWrapper dependencyWrapper : dependencyWrapperList) {
                replacementParentNode.appendChild(dependencyWrapper.getDependencyNode());
            }
        }
        return replacementParentNode;
    }
}

