/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.forge.style;

import com.sun.jdi.connect.TransportTimeoutException;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.smallmind.forge.style.DependencyReference;
import org.smallmind.forge.style.DependencyWrapper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DependencyReducer {
    public static void main(String ... args) throws IOException {
        DependencyReducer.walkProject(Paths.get(args[0], new String[0]));
    }

    public static void walkProject(final Path projectPath) throws IOException {
        final String mvnPath = DependencyReducer.findMvn(projectPath);
        if (mvnPath == null) {
            throw new RuntimeException("Unable to locate 'mvn.cmd'");
        }
        Files.walkFileTree(projectPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                if (!dir.equals(projectPath) && !DependencyReducer.dottedPath(dir) && Files.exists(dir.resolve("pom.xml"), new LinkOption[0])) {
                    LinkedList<DependencyReference> usedUndeclaredList = new LinkedList<DependencyReference>();
                    LinkedList<DependencyReference> unusedDeclaredList = new LinkedList<DependencyReference>();
                    LinkedList<DependencyReference> nonTestScopedTestOnlyList = new LinkedList<DependencyReference>();
                    ByteArrayOutputStream buffer = DependencyReducer.bufferProcessOutput(dir, mvnPath, "dependency:analyze", "-N");
                    System.out.println(dir);
                    try (BufferedReader lineReader = new BufferedReader(new StringReader(buffer.toString(StandardCharsets.UTF_8)));){
                        String singleLine;
                        ParseState state = ParseState.IGNORED;
                        while ((singleLine = lineReader.readLine()) != null) {
                            if (singleLine.endsWith("Used undeclared dependencies found:")) {
                                state = ParseState.USED_UNDECLARED;
                                continue;
                            }
                            if (singleLine.endsWith("Unused declared dependencies found:")) {
                                state = ParseState.UNUSED_DECLARED;
                                continue;
                            }
                            if (singleLine.endsWith("Non-test scoped test only dependencies found:")) {
                                state = ParseState.NON_TEST_SCOPED_TEST_ONLY;
                                continue;
                            }
                            if (singleLine.endsWith("------------------------------------------------------------------------")) {
                                break;
                            }
                            if (ParseState.USED_UNDECLARED.equals((Object)state)) {
                                usedUndeclaredList.add(new DependencyReference(singleLine.substring("[WARNING]    ".length())));
                                continue;
                            }
                            if (ParseState.UNUSED_DECLARED.equals((Object)state)) {
                                unusedDeclaredList.add(new DependencyReference(singleLine.substring("[WARNING]    ".length())));
                                continue;
                            }
                            if (!ParseState.NON_TEST_SCOPED_TEST_ONLY.equals((Object)state)) continue;
                            nonTestScopedTestOnlyList.add(new DependencyReference(singleLine.substring("[WARNING]    ".length())));
                        }
                    }
                    if (!(usedUndeclaredList.isEmpty() && unusedDeclaredList.isEmpty() && nonTestScopedTestOnlyList.isEmpty())) {
                        try {
                            DependencyReducer.rewritePom(dir.resolve("pom.xml"), usedUndeclaredList, unusedDeclaredList, nonTestScopedTestOnlyList);
                        }
                        catch (ParserConfigurationException | TransformerException | SAXException exception) {
                            throw new RuntimeException(exception);
                        }
                    }
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private static String findMvn(Path commandDir) throws IOException {
        ByteArrayOutputStream buffer = DependencyReducer.bufferProcessOutput(commandDir, "where.exe", "mvn.cmd");
        String result = buffer.toString();
        if (result == null || result.isBlank() || result.startsWith("INFO: ")) {
            return null;
        }
        return result.strip();
    }

    private static boolean dottedPath(Path path) {
        for (int index = 0; index < path.getNameCount(); ++index) {
            if (path.getName(index).toString().charAt(0) != '.') continue;
            return true;
        }
        return false;
    }

    private static ByteArrayOutputStream bufferProcessOutput(Path commandDir, String ... commands) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        Process process = new ProcessBuilder(commands).directory(commandDir.toFile()).start();
        try (InputStream processStream = process.getInputStream();){
            int singleChar;
            while ((singleChar = processStream.read()) >= 0) {
                buffer.write(singleChar);
            }
        }
        try {
            if (!process.waitFor(3L, TimeUnit.SECONDS)) {
                throw new TransportTimeoutException();
            }
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
        buffer.close();
        return buffer;
    }

    private static void rewritePom(Path pomPath, List<DependencyReference> usedUndeclaredList, LinkedList<DependencyReference> unusedDeclaredList, LinkedList<DependencyReference> nonTestScopedTestOnlyList) throws IOException, SAXException, ParserConfigurationException, TransformerException {
        Node projectNode;
        NodeList dependenciesNodeList;
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(Files.newInputStream(pomPath, new OpenOption[0]));
        NodeList projectNodeList = doc.getElementsByTagName("project");
        boolean changed = false;
        if (projectNodeList.getLength() > 0 && (dependenciesNodeList = ((Element)(projectNode = projectNodeList.item(0))).getElementsByTagName("dependencies")).getLength() > 0) {
            for (int dependenciesIndex = 0; dependenciesIndex < dependenciesNodeList.getLength(); ++dependenciesIndex) {
                Node dependenciesNode = dependenciesNodeList.item(dependenciesIndex);
                if (!dependenciesNode.getParentNode().equals(projectNode)) continue;
                Node adjustedDepenenciesNode = DependencyReducer.adjustDependencies(dependenciesNode, usedUndeclaredList, unusedDeclaredList, nonTestScopedTestOnlyList);
                if (adjustedDepenenciesNode == null) break;
                changed = true;
                if (adjustedDepenenciesNode.hasChildNodes()) {
                    projectNode.replaceChild(adjustedDepenenciesNode, dependenciesNode);
                    break;
                }
                projectNode.removeChild(dependenciesNode);
                break;
            }
        }
        if (changed) {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer(new StreamSource(Thread.currentThread().getContextClassLoader().getResourceAsStream("org/smallmind/forge/style/pretty-print.xslt")));
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(Files.newOutputStream(pomPath, new OpenOption[0]));
            transformer.setOutputProperty("standalone", "no");
            transformer.transform(source, result);
        }
    }

    private static Node adjustDependencies(Node parentNode, List<DependencyReference> usedUndeclaredList, LinkedList<DependencyReference> unusedDeclaredList, LinkedList<DependencyReference> nonTestScopedTestOnlyList) {
        Node replacementParentNode = parentNode.cloneNode(false);
        boolean changed = false;
        NodeList dependencyNodeList = ((Element)parentNode).getElementsByTagName("dependency");
        LinkedList<DependencyWrapper> dependencyWrapperList = new LinkedList<DependencyWrapper>();
        if (dependencyNodeList.getLength() > 0) {
            for (int dependencyIndex = 0; dependencyIndex < dependencyNodeList.getLength(); ++dependencyIndex) {
                Node dependencyNode = dependencyNodeList.item(dependencyIndex);
                dependencyWrapperList.add(new DependencyWrapper(dependencyNode));
            }
        }
        block1: for (DependencyReference unusedDeclaredReference : unusedDeclaredList) {
            Iterator definedDependencyIter = dependencyWrapperList.iterator();
            while (definedDependencyIter.hasNext()) {
                DependencyWrapper definedWrapper = (DependencyWrapper)definedDependencyIter.next();
                if (!definedWrapper.getGroupId().equals(unusedDeclaredReference.getGroupId()) || !definedWrapper.getArtifactId().equals(unusedDeclaredReference.getArtifactId())) continue;
                changed = true;
                definedDependencyIter.remove();
                continue block1;
            }
        }
        for (DependencyReference usedUndeclaredReference : usedUndeclaredList) {
            changed = true;
            dependencyWrapperList.add(new DependencyWrapper(DependencyReducer.createDependencyElement(parentNode.getOwnerDocument(), usedUndeclaredReference)));
        }
        block4: for (DependencyReference nonTestScopedTestOnlyReference : nonTestScopedTestOnlyList) {
            for (DependencyWrapper definedWrapper : dependencyWrapperList) {
                if (!definedWrapper.getGroupId().equals(nonTestScopedTestOnlyReference.getGroupId()) || !definedWrapper.getArtifactId().equals(nonTestScopedTestOnlyReference.getArtifactId())) continue;
                NodeList scopeNodeList = ((Element)definedWrapper.getDependencyNode()).getElementsByTagName("scope");
                changed = true;
                if (scopeNodeList.getLength() > 0) {
                    scopeNodeList.item(0).setTextContent("test");
                    continue block4;
                }
                Element scopeElement = parentNode.getOwnerDocument().createElement("scope");
                scopeElement.setTextContent("test");
                definedWrapper.getDependencyNode().appendChild(scopeElement);
                continue block4;
            }
        }
        if (!changed) {
            return null;
        }
        Collections.sort(dependencyWrapperList);
        for (DependencyWrapper dependencyWrapper : dependencyWrapperList) {
            replacementParentNode.appendChild(dependencyWrapper.getDependencyNode());
        }
        return replacementParentNode;
    }

    private static Element createDependencyElement(Document document, DependencyReference dependencyReference) {
        Element addedDependency = document.createElement("dependency");
        Element groupIdElement = document.createElement("groupId");
        Element artifactElement = document.createElement("artifactId");
        Element scopeElement = document.createElement("scope");
        groupIdElement.setTextContent(dependencyReference.getGroupId());
        artifactElement.setTextContent(dependencyReference.getArtifactId());
        scopeElement.setTextContent(dependencyReference.getScope());
        addedDependency.appendChild(groupIdElement);
        addedDependency.appendChild(artifactElement);
        addedDependency.appendChild(scopeElement);
        return addedDependency;
    }

    private static enum ParseState {
        IGNORED,
        USED_UNDECLARED,
        UNUSED_DECLARED,
        NON_TEST_SCOPED_TEST_ONLY;

    }
}

