/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.cloud.cluster;

import java.util.HashMap;
import org.smallmind.cloud.cluster.ClusterHub;
import org.smallmind.cloud.cluster.ClusterInstance;
import org.smallmind.cloud.cluster.ClusterManagementException;
import org.smallmind.cloud.cluster.ClusterMember;
import org.smallmind.cloud.cluster.ClusterService;
import org.smallmind.cloud.cluster.ClusterServiceBuilder;
import org.smallmind.cloud.cluster.protocol.ClusterProtocol;
import org.smallmind.cloud.cluster.protocol.ClusterProtocolDetails;

public class ClusterServiceFactory {
    private static final HashMap<ClusterProtocol, ClusterServiceBuilder> PROTOCOL_MAP = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClusterService getClusterService(ClusterHub clusterHub, ClusterInstance clusterInstance, ClusterMember clusterMember) throws ClusterManagementException {
        ClusterServiceBuilder<? extends ClusterProtocolDetails> clusterServiceBuilder;
        HashMap<ClusterProtocol, ClusterServiceBuilder> hashMap = PROTOCOL_MAP;
        synchronized (hashMap) {
            clusterServiceBuilder = PROTOCOL_MAP.get((Object)((ClusterProtocolDetails)clusterInstance.getClusterInterface().getClusterProtocolDetails()).getClusterProtocol());
            if (clusterServiceBuilder == null) {
                try {
                    clusterServiceBuilder = ((ClusterProtocolDetails)clusterInstance.getClusterInterface().getClusterProtocolDetails()).getClusterProtocol().getServiceBuilderClass().newInstance();
                }
                catch (Exception exception) {
                    throw new ClusterManagementException(exception);
                }
                PROTOCOL_MAP.put(((ClusterProtocolDetails)clusterInstance.getClusterInterface().getClusterProtocolDetails()).getClusterProtocol(), clusterServiceBuilder);
            }
        }
        ClusterService clusterService = clusterServiceBuilder.getClusterService(clusterHub, clusterInstance);
        clusterService.bindClusterMember(clusterMember);
        return clusterService;
    }
}

