/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.cloud.cluster.protocol.queue;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import javax.jms.JMSException;
import org.smallmind.cloud.cluster.ClusterEndpoint;
import org.smallmind.cloud.cluster.ClusterHandle;
import org.smallmind.cloud.cluster.ClusterHub;
import org.smallmind.cloud.cluster.ClusterInterface;
import org.smallmind.cloud.cluster.ClusterManagementException;
import org.smallmind.cloud.cluster.ClusterManager;
import org.smallmind.cloud.cluster.protocol.queue.QueueClusterHandle;
import org.smallmind.cloud.cluster.protocol.queue.QueueClusterProtocolDetails;
import org.smallmind.quorum.transport.messaging.MessagingInvocationHandler;
import org.smallmind.quorum.transport.messaging.MessagingTransmitter;

public class QueueClusterManager
implements ClusterManager<QueueClusterProtocolDetails> {
    private ClusterHub clusterHub;
    private Proxy clusterProxy;
    private ClusterInterface<QueueClusterProtocolDetails> clusterInterface;
    private MessagingTransmitter messagingTransmitter;

    public QueueClusterManager(ClusterHub clusterHub, ClusterInterface<QueueClusterProtocolDetails> clusterInterface) throws ClusterManagementException {
        this.clusterHub = clusterHub;
        this.clusterInterface = clusterInterface;
        try {
            this.messagingTransmitter = new MessagingTransmitter(clusterInterface.getClusterProtocolDetails().getConnectionDetails());
        }
        catch (Exception exception) {
            throw new ClusterManagementException(exception);
        }
        QueueClusterHandle clusterHandle = new QueueClusterHandle(new MessagingInvocationHandler(this.messagingTransmitter, clusterInterface.getClusterProtocolDetails().getServiceInterface()));
        this.clusterProxy = (Proxy)Proxy.newProxyInstance(clusterInterface.getClusterProtocolDetails().getServiceInterface().getClassLoader(), new Class[]{ClusterHandle.class, clusterInterface.getClusterProtocolDetails().getServiceInterface()}, (InvocationHandler)clusterHandle);
    }

    @Override
    public ClusterInterface<QueueClusterProtocolDetails> getClusterInterface() {
        return this.clusterInterface;
    }

    @Override
    public ClusterHandle getClusterHandle() throws ClusterManagementException {
        return (ClusterHandle)((Object)this.clusterProxy);
    }

    @Override
    public void updateClusterStatus(ClusterEndpoint clusterEndpoint, int calibratedFreeCapacity) {
    }

    @Override
    public void removeClusterMember(ClusterEndpoint clusterEndpoint) {
    }

    public void finalize() {
        try {
            this.messagingTransmitter.close();
        }
        catch (JMSException j) {
            this.clusterHub.logError(j);
        }
    }
}

