/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.cloud.cluster.protocol.remote;

import java.rmi.Naming;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import org.smallmind.cloud.cluster.ClusterHub;
import org.smallmind.cloud.cluster.ClusterInstance;
import org.smallmind.cloud.cluster.ClusterManagementException;
import org.smallmind.cloud.cluster.ClusterMember;
import org.smallmind.cloud.cluster.ClusterService;
import org.smallmind.cloud.cluster.broadcast.ServiceClusterBroadcast;
import org.smallmind.cloud.cluster.protocol.remote.RemoteClusterProtocolDetails;
import org.smallmind.cloud.cluster.protocol.remote.RemoteClusterService;
import org.smallmind.cloud.multicast.EventMessageException;
import org.smallmind.quorum.transport.InvocationSignal;
import org.smallmind.quorum.transport.MethodInvoker;

public class RemoteClusterServiceImpl
extends UnicastRemoteObject
implements RemoteClusterService,
ClusterService<RemoteClusterProtocolDetails> {
    private static final String RMI_NAME_PREFIX = "org.smallmind.cloud.cluster.protocol.remote.";
    private ClusterHub clusterHub;
    private ClusterMember clusterMember = null;
    private ClusterInstance<RemoteClusterProtocolDetails> clusterInstance;
    private MethodInvoker methodInvoker;
    private boolean open = true;

    public RemoteClusterServiceImpl(ClusterHub clusterHub, ClusterInstance<RemoteClusterProtocolDetails> clusterInstance) throws RemoteException {
        this.clusterHub = clusterHub;
        this.clusterInstance = clusterInstance;
    }

    @Override
    public ClusterInstance<RemoteClusterProtocolDetails> getClusterInstance() {
        return this.clusterInstance;
    }

    @Override
    public void bindClusterMember(ClusterMember clusterMember) throws ClusterManagementException {
        this.clusterMember = clusterMember;
        try {
            this.methodInvoker = new MethodInvoker((Object)clusterMember, new Class[]{this.clusterInstance.getClusterInterface().getClusterProtocolDetails().getServiceInterface()});
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ClusterManagementException(noSuchMethodException);
        }
    }

    @Override
    public Object remoteInvocation(InvocationSignal invocationSignal) throws Exception {
        if (this.methodInvoker == null) {
            throw new IllegalStateException("No ClusterMember(" + this.clusterInstance.getClusterInterface().getClusterProtocolDetails().getServiceInterface().getCanonicalName() + ") has been bound to this service representation");
        }
        return this.methodInvoker.remoteInvocation(invocationSignal);
    }

    @Override
    public synchronized void fireServiceBroadcast(ServiceClusterBroadcast serviceClusterBroadcast) throws EventMessageException {
        if (!this.open) {
            throw new IllegalStateException("The service has already been closed");
        }
        this.clusterHub.fireEvent(serviceClusterBroadcast);
    }

    @Override
    public synchronized void handleServiceBroadcast(ServiceClusterBroadcast serviceClusterBroadcast) {
        if (!this.open) {
            throw new IllegalStateException("The service has already been closed");
        }
        this.clusterMember.handleServiceBroadcast(serviceClusterBroadcast);
    }

    @Override
    public synchronized void start() throws ClusterManagementException {
        if (!this.open) {
            try {
                Naming.rebind(RMI_NAME_PREFIX + this.clusterInstance.getClusterInterface().getClusterName() + ".instance." + this.clusterInstance.getInstanceId(), this);
            }
            catch (Exception exception) {
                throw new ClusterManagementException(exception);
            }
            this.clusterHub.addClusterService(this);
            this.open = true;
        }
    }

    @Override
    public synchronized void stop() {
        if (this.open) {
            this.open = false;
            this.clusterHub.removeClusterService(this.getClusterInstance());
            try {
                Naming.unbind(RMI_NAME_PREFIX + this.clusterInstance.getClusterInterface().getClusterName() + ".instance." + this.clusterInstance.getInstanceId());
            }
            catch (Exception exception) {
                this.clusterHub.logError(exception);
            }
        }
    }
}

