/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.cloud.cluster;

import java.io.IOException;
import java.net.InetAddress;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.smallmind.cloud.cluster.ClusterEndpoint;
import org.smallmind.cloud.cluster.ClusterHubBroadcastDelivery;
import org.smallmind.cloud.cluster.ClusterHubGossipDelivery;
import org.smallmind.cloud.cluster.ClusterInstance;
import org.smallmind.cloud.cluster.ClusterInterface;
import org.smallmind.cloud.cluster.ClusterManagementException;
import org.smallmind.cloud.cluster.ClusterManager;
import org.smallmind.cloud.cluster.ClusterService;
import org.smallmind.cloud.cluster.ClusterUpdateTimer;
import org.smallmind.cloud.cluster.broadcast.ClusterBroadcast;
import org.smallmind.cloud.cluster.broadcast.GossipClusterBroadcast;
import org.smallmind.cloud.cluster.broadcast.NodeOfflineClusterBroadcast;
import org.smallmind.cloud.cluster.broadcast.ServiceClusterBroadcast;
import org.smallmind.cloud.cluster.broadcast.UpdateRequestClusterBroadcast;
import org.smallmind.cloud.cluster.broadcast.UpdateResponseClusterBroadcast;
import org.smallmind.cloud.cluster.event.GossipClusterListener;
import org.smallmind.cloud.cluster.meter.CapacityMeter;
import org.smallmind.cloud.multicast.EventMessageException;
import org.smallmind.cloud.multicast.event.EventTransmitter;
import org.smallmind.cloud.multicast.event.MulticastEvent;
import org.smallmind.cloud.multicast.event.MulticastEventHandler;
import org.smallmind.nutsnbolts.util.WeakEventListenerList;
import org.smallmind.quorum.cache.CacheException;
import org.smallmind.scribe.pen.Logger;

public class ClusterHub
implements MulticastEventHandler {
    private static final int PROPAGATION_LATENCY = 3000;
    private final HashMap<ClusterInterface, WeakEventListenerList<GossipClusterListener>> listenerMap;
    private final HashMap<ClusterInterface, ClusterManager> managerMap;
    private final HashMap<ClusterInstance, ClusterService> clientMap;
    private Logger logger;
    private CapacityMeter capacityMeter;
    private EventTransmitter eventTransmitter;
    private ClusterUpdateTimer clusterUpdateTimer;

    public ClusterHub(Logger logger, CapacityMeter capacityMeter, String multicastIP, int multicastPort, int messageSegmentSize, int updateInterval) throws IOException, CacheException {
        this.logger = logger;
        this.capacityMeter = capacityMeter;
        this.managerMap = new HashMap();
        this.clientMap = new HashMap();
        this.listenerMap = new HashMap();
        InetAddress multicastInetAddr = InetAddress.getByName(multicastIP);
        this.eventTransmitter = new EventTransmitter(this, logger, multicastInetAddr, multicastPort, messageSegmentSize);
        this.clusterUpdateTimer = new ClusterUpdateTimer(this, updateInterval);
        Thread updateTimerThread = new Thread(this.clusterUpdateTimer);
        updateTimerThread.setDaemon(true);
        updateTimerThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGossipClusterListener(ClusterInterface clusterInterface, GossipClusterListener gossipClusterListener) {
        WeakEventListenerList listenerList;
        WeakEventListenerList weakEventListenerList = this.listenerMap;
        synchronized (weakEventListenerList) {
            listenerList = this.listenerMap.get(clusterInterface);
            if (listenerList == null) {
                listenerList = new WeakEventListenerList();
                this.listenerMap.put(clusterInterface, (WeakEventListenerList<GossipClusterListener>)listenerList);
            }
        }
        weakEventListenerList = listenerList;
        synchronized (weakEventListenerList) {
            listenerList.addListener((EventListener)gossipClusterListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGossipClusterListener(ClusterInterface clusterInterface, GossipClusterListener gossipClusterListener) {
        HashMap<ClusterInterface, WeakEventListenerList<GossipClusterListener>> hashMap = this.listenerMap;
        synchronized (hashMap) {
            WeakEventListenerList<GossipClusterListener> listenerList = this.listenerMap.get(clusterInterface);
            if (listenerList != null) {
                WeakEventListenerList<GossipClusterListener> weakEventListenerList = listenerList;
                synchronized (weakEventListenerList) {
                    listenerList.removeListener((EventListener)gossipClusterListener);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterManager getClusterManager(ClusterInterface clusterInterface) {
        HashMap<ClusterInterface, ClusterManager> hashMap = this.managerMap;
        synchronized (hashMap) {
            return this.managerMap.get(clusterInterface);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClusterManager(ClusterManager clusterManager) throws ClusterManagementException {
        HashMap<ClusterInterface, ClusterManager> hashMap = this.managerMap;
        synchronized (hashMap) {
            this.managerMap.put(clusterManager.getClusterInterface(), clusterManager);
        }
        this.requestStatusUpdate(clusterManager.getClusterInterface());
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptdException) {
            throw new ClusterManagementException(interruptdException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClusterService(ClusterService clusterService) {
        ClusterInstance clusterInstance = clusterService.getClusterInstance();
        HashMap<ClusterInstance, ClusterService> hashMap = this.clientMap;
        synchronized (hashMap) {
            this.clientMap.put(clusterInstance, clusterService);
        }
        this.fireStatusUpdate(new ClusterInstance[]{clusterInstance});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClusterService(ClusterInstance clusterInstance) {
        HashMap<ClusterInstance, ClusterService> hashMap = this.clientMap;
        synchronized (hashMap) {
            this.clientMap.remove(clusterInstance);
        }
        this.fireClusterNodeOffline(clusterInstance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterInstance[] getClientClusterInstances() {
        ClusterInstance[] clusterInstances;
        HashMap<ClusterInstance, ClusterService> hashMap = this.clientMap;
        synchronized (hashMap) {
            clusterInstances = new ClusterInstance[this.clientMap.keySet().size()];
            this.clientMap.keySet().toArray(clusterInstances);
        }
        return clusterInstances;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterInstance[] getClientClusterInstances(ClusterInterface clusterInterface) {
        LinkedList<ClusterInstance> clusterInstanceList = new LinkedList<ClusterInstance>();
        HashMap<ClusterInstance, ClusterService> hashMap = this.clientMap;
        synchronized (hashMap) {
            for (ClusterInstance clusterInstance : this.clientMap.keySet()) {
                if (!clusterInstance.getClusterInterface().equals(clusterInterface)) continue;
                clusterInstanceList.add(clusterInstance);
            }
        }
        ClusterInstance[] clusterInstances = new ClusterInstance[clusterInstanceList.size()];
        clusterInstanceList.toArray(clusterInstances);
        return clusterInstances;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasServiceCluster(ClusterInterface clusterInterface) {
        HashMap<ClusterInstance, ClusterService> hashMap = this.clientMap;
        synchronized (hashMap) {
            Iterator<ClusterInstance> clusterInstanceIter = this.clientMap.keySet().iterator();
            while (clusterInstanceIter.hasNext()) {
                if (!clusterInstanceIter.next().getClusterInterface().equals(clusterInterface)) continue;
                return true;
            }
        }
        return false;
    }

    private void requestStatusUpdate(ClusterInterface clusterInterface) {
        try {
            this.fireEvent(new UpdateRequestClusterBroadcast(clusterInterface));
        }
        catch (Exception e) {
            this.logError(e);
        }
    }

    protected void fireStatusUpdate(ClusterInstance[] clusterInstances) {
        if (clusterInstances.length > 0) {
            int calibratedFreeCapacity = this.capacityMeter.getCalibratedFreeCapacity();
            try {
                this.fireEvent(new UpdateResponseClusterBroadcast(clusterInstances, calibratedFreeCapacity));
            }
            catch (Exception e) {
                this.logError(e);
            }
        }
    }

    protected void fireClusterNodeOffline(ClusterInstance clusterInstance) {
        try {
            this.fireEvent(new NodeOfflineClusterBroadcast(clusterInstance));
        }
        catch (Exception e) {
            this.logError(e);
        }
    }

    public void fireEvent(MulticastEvent multicastEvent) throws EventMessageException {
        this.eventTransmitter.fireEvent(multicastEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deliverEvent(MulticastEvent multicastEvent) {
        if (multicastEvent instanceof ClusterBroadcast) {
            switch (((ClusterBroadcast)multicastEvent).getClusterBroadcastType()) {
                case SYSTEM: {
                    if (multicastEvent instanceof UpdateRequestClusterBroadcast) {
                        this.fireStatusUpdate(this.getClientClusterInstances(((UpdateRequestClusterBroadcast)multicastEvent).getClusterInterface()));
                        break;
                    }
                    if (multicastEvent instanceof UpdateResponseClusterBroadcast) {
                        HashMap<ClusterInterface, ClusterManager> hashMap = this.managerMap;
                        synchronized (hashMap) {
                            ClusterInstance[] clusterInstances;
                            int calibratedFreeCapacity = ((UpdateResponseClusterBroadcast)multicastEvent).getCalibratedFreeCapacity();
                            for (ClusterInstance clusterInstance : clusterInstances = ((UpdateResponseClusterBroadcast)multicastEvent).getClusterInstances()) {
                                ClusterManager clusterManager = this.managerMap.get(clusterInstance.getClusterInterface());
                                if (clusterManager == null) continue;
                                try {
                                    clusterManager.updateClusterStatus(new ClusterEndpoint(multicastEvent.getHostAddress(), clusterInstance), calibratedFreeCapacity);
                                }
                                catch (Exception e) {
                                    this.logError(e);
                                }
                            }
                            break;
                        }
                    }
                    if (!(multicastEvent instanceof NodeOfflineClusterBroadcast)) break;
                    HashMap<ClusterInterface, ClusterManager> calibratedFreeCapacity = this.managerMap;
                    synchronized (calibratedFreeCapacity) {
                        ClusterInstance clusterInstance = ((NodeOfflineClusterBroadcast)multicastEvent).getClusterInstance();
                        ClusterManager clusterManager = this.managerMap.get(clusterInstance.getClusterInterface());
                        if (clusterManager != null) {
                            try {
                                clusterManager.removeClusterMember(new ClusterEndpoint(multicastEvent.getHostAddress(), clusterInstance));
                            }
                            catch (Exception e) {
                                this.logError(e);
                            }
                        }
                        break;
                    }
                }
                case SERVICE: {
                    HashMap<ClusterInstance, ClusterService> clusterInstance = this.clientMap;
                    synchronized (clusterInstance) {
                        ClusterInstance[] clusterInstances;
                        for (ClusterInstance clusterInstance2 : clusterInstances = this.getClientClusterInstances(((ServiceClusterBroadcast)multicastEvent).getClusterInterface())) {
                            this.spinThread(new ClusterHubBroadcastDelivery(this.clientMap.get(clusterInstance2), (ServiceClusterBroadcast)multicastEvent));
                        }
                        break;
                    }
                }
                case GOSSIP: {
                    WeakEventListenerList<GossipClusterListener> listenerList;
                    HashMap<ClusterInterface, WeakEventListenerList<GossipClusterListener>> hashMap = this.listenerMap;
                    synchronized (hashMap) {
                        listenerList = this.listenerMap.get(((GossipClusterBroadcast)multicastEvent).getClusterInsterface());
                    }
                    if (listenerList == null) break;
                    hashMap = listenerList;
                    synchronized (hashMap) {
                        if (listenerList != null) {
                            Iterator listenerIter = listenerList.getListeners();
                            while (listenerIter.hasNext()) {
                                this.spinThread(new ClusterHubGossipDelivery((GossipClusterListener)listenerIter.next(), ((GossipClusterBroadcast)multicastEvent).getGossipClusterEvent()));
                            }
                        }
                        break;
                    }
                }
                default: {
                    this.logError("Unkown cluster broadacst type (" + ((ClusterBroadcast)multicastEvent).getClusterBroadcastType().name() + ")");
                }
            }
        }
    }

    private void spinThread(Runnable runnable) {
        Thread thread = new Thread(runnable);
        thread.start();
    }

    public void finalize() {
        try {
            this.clusterUpdateTimer.finish();
        }
        catch (InterruptedException interruptedException) {
            this.logError(interruptedException);
        }
        this.eventTransmitter.finish();
    }

    public void logError(String message) {
        this.logger.error((Object)message);
    }

    public void logError(Throwable throwable) {
        this.logger.error(throwable);
    }
}

