/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.cloud.cluster.protocol.socket;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import org.smallmind.cloud.cluster.ClusterEndpoint;
import org.smallmind.cloud.cluster.ClusterHandle;
import org.smallmind.cloud.cluster.ClusterHub;
import org.smallmind.cloud.cluster.ClusterInterface;
import org.smallmind.cloud.cluster.ClusterManagementException;
import org.smallmind.cloud.cluster.ClusterManager;
import org.smallmind.cloud.cluster.protocol.socket.SocketClusterHandle;
import org.smallmind.cloud.cluster.protocol.socket.SocketClusterProtocolDetails;

public class SocketClusterManager
implements ClusterManager<SocketClusterProtocolDetails> {
    private ClusterHub clusterHub;
    private SocketClusterHandle socketClusterHandle;
    private ClusterInterface<SocketClusterProtocolDetails> clusterInterface;

    public SocketClusterManager(ClusterHub clusterHub, ClusterInterface<SocketClusterProtocolDetails> clusterInterface) {
        this.clusterHub = clusterHub;
        this.clusterInterface = clusterInterface;
        this.socketClusterHandle = new SocketClusterHandle(this);
    }

    @Override
    public ClusterInterface<SocketClusterProtocolDetails> getClusterInterface() {
        return this.clusterInterface;
    }

    @Override
    public ClusterHandle getClusterHandle() {
        return this.socketClusterHandle;
    }

    @Override
    public void updateClusterStatus(ClusterEndpoint clusterEndpoint, int calibratedFreeCapacity) {
        this.clusterInterface.getClusterPivot().updateClusterStatus(clusterEndpoint, calibratedFreeCapacity);
    }

    @Override
    public void removeClusterMember(ClusterEndpoint clusterEndpoint) {
        this.clusterInterface.getClusterPivot().removeClusterMember(clusterEndpoint);
    }

    private int getServicePort(String instanceId) throws ClusterManagementException {
        return this.clusterInterface.getClusterProtocolDetails().getPortMapper().mapPort(instanceId);
    }

    public SocketChannel connect(Object[] parameters) throws ClusterManagementException {
        ClusterEndpoint clusterEndpoint = null;
        while (true) {
            if ((clusterEndpoint = this.clusterInterface.getClusterPivot().nextRequestAddress(parameters, clusterEndpoint)) == null) {
                throw new ClusterManagementException("No server is currently available for requests to %s (%s)", ClusterInterface.class.getSimpleName(), this.clusterInterface);
            }
            InetSocketAddress serviceSocketAddress = new InetSocketAddress(clusterEndpoint.getHostAddress(), this.getServicePort(clusterEndpoint.getClusterInstance().getInstanceId()));
            try {
                SocketChannel serviceSocketChannel = SocketChannel.open(serviceSocketAddress);
                return serviceSocketChannel;
            }
            catch (IOException ioException) {
                this.clusterHub.logError(ioException);
                this.removeClusterMember(clusterEndpoint);
                continue;
            }
            break;
        }
    }
}

