/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.cloud.cluster.protocol.socket;

import org.smallmind.cloud.cluster.ClusterHub;
import org.smallmind.cloud.cluster.ClusterInstance;
import org.smallmind.cloud.cluster.ClusterMember;
import org.smallmind.cloud.cluster.ClusterService;
import org.smallmind.cloud.cluster.broadcast.ServiceClusterBroadcast;
import org.smallmind.cloud.cluster.protocol.socket.SocketClusterProtocolDetails;
import org.smallmind.cloud.multicast.EventMessageException;

public class SocketClusterService
implements ClusterService<SocketClusterProtocolDetails> {
    private ClusterHub clusterHub;
    private ClusterMember clusterMember;
    private ClusterInstance<SocketClusterProtocolDetails> clusterInstance;
    private boolean open = true;

    public SocketClusterService(ClusterHub clusterHub, ClusterInstance<SocketClusterProtocolDetails> clusterInstance) {
        this.clusterHub = clusterHub;
        this.clusterInstance = clusterInstance;
    }

    @Override
    public ClusterInstance<SocketClusterProtocolDetails> getClusterInstance() {
        return this.clusterInstance;
    }

    @Override
    public void bindClusterMember(ClusterMember clusterMember) {
        this.clusterMember = clusterMember;
    }

    @Override
    public synchronized void fireServiceBroadcast(ServiceClusterBroadcast serviceClusterBroadcast) throws EventMessageException {
        if (!this.open) {
            throw new IllegalStateException("The service has already been closed");
        }
        this.clusterHub.fireEvent(serviceClusterBroadcast);
    }

    @Override
    public synchronized void handleServiceBroadcast(ServiceClusterBroadcast serviceClusterBroadcast) {
        if (!this.open) {
            throw new IllegalStateException("The service has already been closed");
        }
        this.clusterMember.handleServiceBroadcast(serviceClusterBroadcast);
    }

    @Override
    public synchronized void start() {
        if (!this.open) {
            this.clusterHub.addClusterService(this);
            this.open = true;
        }
    }

    @Override
    public synchronized void stop() {
        if (this.open) {
            this.open = false;
            this.clusterHub.removeClusterService(this.getClusterInstance());
        }
    }
}

