/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.cloud.cluster;

import java.io.Serializable;
import java.net.InetAddress;
import org.smallmind.cloud.cluster.ClusterInstance;

public class ClusterEndpoint
implements Serializable {
    private InetAddress inetAddress;
    private ClusterInstance clusterInstance;

    public ClusterEndpoint(InetAddress inetAddress, ClusterInstance clusterInstance) {
        this.inetAddress = inetAddress;
        this.clusterInstance = clusterInstance;
    }

    public InetAddress getHostAddress() {
        return this.inetAddress;
    }

    public String getHostName() {
        return this.inetAddress.getHostName();
    }

    public ClusterInstance getClusterInstance() {
        return this.clusterInstance;
    }

    public String toString() {
        StringBuilder endpointBuilder = new StringBuilder("ClusterEndpoint [");
        endpointBuilder.append(this.inetAddress.toString());
        endpointBuilder.append(":");
        endpointBuilder.append(this.clusterInstance.toString());
        endpointBuilder.append("]");
        return endpointBuilder.toString();
    }

    public int hashCode() {
        return this.inetAddress.hashCode() ^ this.clusterInstance.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof ClusterEndpoint && this.inetAddress.equals(((ClusterEndpoint)obj).getHostAddress()) && this.clusterInstance.equals(((ClusterEndpoint)obj).getClusterInstance());
    }
}

