/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.cloud.cluster;

import java.util.HashMap;
import org.smallmind.cloud.cluster.ClusterHandle;
import org.smallmind.cloud.cluster.ClusterHub;
import org.smallmind.cloud.cluster.ClusterInterface;
import org.smallmind.cloud.cluster.ClusterManagementException;
import org.smallmind.cloud.cluster.ClusterManager;
import org.smallmind.cloud.cluster.ClusterManagerBuilder;
import org.smallmind.cloud.cluster.protocol.ClusterProtocol;
import org.smallmind.cloud.cluster.protocol.ClusterProtocolDetails;

public class ClusterManagerFactory {
    private static final HashMap<ClusterProtocol, ClusterManagerBuilder> PROTOCOL_MAP = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClusterHandle getClusterHandle(ClusterHub clusterHub, ClusterInterface clusterInterface) throws ClusterManagementException {
        ClusterManager clusterManager = clusterHub.getClusterManager(clusterInterface);
        if (clusterManager == null) {
            ClusterManagerBuilder<? extends ClusterProtocolDetails> clusterManagerBuilder;
            HashMap<ClusterProtocol, ClusterManagerBuilder> hashMap = PROTOCOL_MAP;
            synchronized (hashMap) {
                clusterManagerBuilder = PROTOCOL_MAP.get((Object)((ClusterProtocolDetails)clusterInterface.getClusterProtocolDetails()).getClusterProtocol());
                if (clusterManagerBuilder == null) {
                    try {
                        clusterManagerBuilder = ((ClusterProtocolDetails)clusterInterface.getClusterProtocolDetails()).getClusterProtocol().getManagerBuilderClass().newInstance();
                    }
                    catch (Exception exception) {
                        throw new ClusterManagementException(exception);
                    }
                    PROTOCOL_MAP.put(((ClusterProtocolDetails)clusterInterface.getClusterProtocolDetails()).getClusterProtocol(), clusterManagerBuilder);
                }
            }
            clusterManager = clusterManagerBuilder.getClusterManager(clusterHub, clusterInterface);
            clusterHub.addClusterManager(clusterManager);
        }
        return clusterManager.getClusterHandle();
    }
}

