/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.cloud.cluster.pivot;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Random;
import org.smallmind.cloud.cluster.ClusterEndpoint;
import org.smallmind.cloud.cluster.pivot.ClusterPivot;

public class RandomWeightedClusterPivot
implements ClusterPivot {
    private static final Random random = new Random();
    private final HashMap<ClusterEndpoint, Integer> endpointMap = new HashMap();
    private ClusterEndpoint[] endpointArray = new ClusterEndpoint[0];
    private int[] sumArray = new int[0];
    private int sumTotal = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateClusterStatus(ClusterEndpoint clusterEndpoint, int freeCapacity) {
        HashMap<ClusterEndpoint, Integer> hashMap = this.endpointMap;
        synchronized (hashMap) {
            this.endpointMap.put(clusterEndpoint, freeCapacity);
        }
        this.createDistribution();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeClusterMember(ClusterEndpoint clusterEndpoint) {
        HashMap<ClusterEndpoint, Integer> hashMap = this.endpointMap;
        synchronized (hashMap) {
            this.endpointMap.remove(clusterEndpoint);
        }
        this.createDistribution();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClusterEndpoint nextRequestAddress(Object[] parameters, ClusterEndpoint failedEndpoint) {
        RandomWeightedClusterPivot randomWeightedClusterPivot = this;
        synchronized (randomWeightedClusterPivot) {
            int endpointIndex;
            if (this.endpointArray.length == 0) {
                return null;
            }
            if (this.sumTotal == 0) {
                endpointIndex = random.nextInt(this.endpointArray.length);
            } else {
                int randomIndex = random.nextInt(this.sumTotal) + 1;
                endpointIndex = Arrays.binarySearch(this.sumArray, randomIndex);
                if (endpointIndex < 0) {
                    endpointIndex = Math.abs(endpointIndex) - 1;
                }
            }
            return this.endpointArray[endpointIndex];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDistribution() {
        int[] tempSumArray;
        ClusterEndpoint[] tempEndpointArray;
        int tempSumTotal = 0;
        int index = 0;
        Object object = this.endpointMap;
        synchronized (object) {
            tempEndpointArray = new ClusterEndpoint[this.endpointMap.size()];
            tempSumArray = new int[this.endpointMap.size()];
            for (ClusterEndpoint endpointKey : this.endpointMap.keySet()) {
                int freeCapacity = this.endpointMap.get(endpointKey);
                tempEndpointArray[index] = endpointKey;
                tempSumArray[index] = tempSumTotal += freeCapacity;
                ++index;
            }
        }
        object = this;
        synchronized (object) {
            this.endpointArray = tempEndpointArray;
            this.sumArray = tempSumArray;
            this.sumTotal = tempSumTotal;
        }
    }
}

