/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.cloud.cluster.protocol.queue;

import org.smallmind.cloud.cluster.ClusterHub;
import org.smallmind.cloud.cluster.ClusterInstance;
import org.smallmind.cloud.cluster.ClusterManagementException;
import org.smallmind.cloud.cluster.ClusterMember;
import org.smallmind.cloud.cluster.ClusterService;
import org.smallmind.cloud.cluster.broadcast.ServiceClusterBroadcast;
import org.smallmind.cloud.cluster.protocol.queue.QueueClusterProtocolDetails;
import org.smallmind.cloud.multicast.EventMessageException;
import org.smallmind.quorum.transport.messaging.MessageTarget;
import org.smallmind.quorum.transport.messaging.MessagingReceiver;

public class QueueClusterService
implements ClusterService<QueueClusterProtocolDetails> {
    private ClusterHub clusterHub;
    private MessagingReceiver messagingReceiver;
    private ClusterMember clusterMember;
    private ClusterInstance<QueueClusterProtocolDetails> clusterInstance;
    private boolean open = true;

    public QueueClusterService(ClusterHub clusterHub, ClusterInstance<QueueClusterProtocolDetails> clusterInstance) {
        this.clusterHub = clusterHub;
        this.clusterInstance = clusterInstance;
    }

    @Override
    public ClusterInstance<QueueClusterProtocolDetails> getClusterInstance() {
        return this.clusterInstance;
    }

    @Override
    public void bindClusterMember(ClusterMember clusterMember) {
        this.clusterMember = clusterMember;
    }

    @Override
    public synchronized void fireServiceBroadcast(ServiceClusterBroadcast serviceClusterBroadcast) throws EventMessageException {
        if (!this.open) {
            throw new IllegalStateException("The service has already been closed");
        }
        this.clusterHub.fireEvent(serviceClusterBroadcast);
    }

    @Override
    public synchronized void handleServiceBroadcast(ServiceClusterBroadcast serviceClusterBroadcast) {
        if (!this.open) {
            throw new IllegalStateException("The service has already been closed");
        }
        this.clusterMember.handleServiceBroadcast(serviceClusterBroadcast);
    }

    @Override
    public synchronized void start() throws ClusterManagementException {
        if (!this.open) {
            try {
                this.messagingReceiver = new MessagingReceiver((MessageTarget)this.clusterMember, this.clusterInstance.getClusterInterface().getClusterProtocolDetails().getConnectionDetails());
            }
            catch (Exception exception) {
                throw new ClusterManagementException(exception);
            }
            this.clusterHub.addClusterService(this);
            this.open = true;
        }
    }

    @Override
    public synchronized void stop() {
        if (this.open) {
            this.open = false;
            this.clusterHub.removeClusterService(this.getClusterInstance());
            this.messagingReceiver.close();
        }
    }
}

