/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.cloud.cluster.protocol.remote;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.RemoteException;
import java.util.HashMap;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.smallmind.cloud.cluster.ClusterEndpoint;
import org.smallmind.cloud.cluster.ClusterHandle;
import org.smallmind.cloud.cluster.ClusterHub;
import org.smallmind.cloud.cluster.ClusterInterface;
import org.smallmind.cloud.cluster.ClusterManagementException;
import org.smallmind.cloud.cluster.ClusterManager;
import org.smallmind.cloud.cluster.protocol.remote.RemoteClusterHandle;
import org.smallmind.cloud.cluster.protocol.remote.RemoteClusterProtocolDetails;
import org.smallmind.cloud.cluster.protocol.remote.RemoteClusterService;
import org.smallmind.nutsnbolts.context.ContextFactory;
import org.smallmind.quorum.transport.FauxMethod;
import org.smallmind.quorum.transport.InvocationSignal;
import org.smallmind.quorum.transport.MissingInvocationException;

public class RemoteClusterManager
implements ClusterManager<RemoteClusterProtocolDetails> {
    private static final String RMI_NAME_PREFIX = "org.smallmind.cloud.cluster.protocol.remote.";
    private final HashMap<ClusterEndpoint, RemoteClusterService> rmiServerMap;
    private ClusterHub clusterHub;
    private Proxy clusterProxy;
    private ClusterInterface<RemoteClusterProtocolDetails> clusterInterface;

    protected RemoteClusterManager(ClusterInterface<RemoteClusterProtocolDetails> clusterInterface) {
        this.clusterInterface = clusterInterface;
        this.rmiServerMap = new HashMap();
        RemoteClusterHandle clusterHandle = new RemoteClusterHandle(this);
        this.clusterProxy = (Proxy)Proxy.newProxyInstance(clusterInterface.getClusterProtocolDetails().getServiceInterface().getClassLoader(), new Class[]{ClusterHandle.class, clusterInterface.getClusterProtocolDetails().getServiceInterface()}, (InvocationHandler)clusterHandle);
    }

    @Override
    public ClusterInterface<RemoteClusterProtocolDetails> getClusterInterface() {
        return this.clusterInterface;
    }

    @Override
    public ClusterHandle getClusterHandle() {
        return (ClusterHandle)((Object)this.clusterProxy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateClusterStatus(ClusterEndpoint clusterEndpoint, int calibratedFreeCapacity) throws ClusterManagementException {
        HashMap<ClusterEndpoint, RemoteClusterService> hashMap = this.rmiServerMap;
        synchronized (hashMap) {
            if (!this.rmiServerMap.containsKey(clusterEndpoint)) {
                RemoteClusterService remoteHandle;
                try {
                    InitialContext initContext = new InitialContext();
                    Context rmiContext = (Context)initContext.lookup("rmi://" + clusterEndpoint.getHostName());
                    remoteHandle = (RemoteClusterService)PortableRemoteObject.narrow((Object)rmiContext.lookup(RMI_NAME_PREFIX + this.clusterInterface.getClusterName() + ".instance." + clusterEndpoint.getClusterInstance().getInstanceId()), RemoteClusterService.class);
                    rmiContext.close();
                    initContext.close();
                }
                catch (NamingException namingException) {
                    throw new ClusterManagementException(namingException);
                }
                this.rmiServerMap.put(clusterEndpoint, remoteHandle);
            }
        }
        this.clusterInterface.getClusterPivot().updateClusterStatus(clusterEndpoint, calibratedFreeCapacity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeClusterMember(ClusterEndpoint clusterEndpoint) {
        HashMap<ClusterEndpoint, RemoteClusterService> hashMap = this.rmiServerMap;
        synchronized (hashMap) {
            if (this.rmiServerMap.containsKey(clusterEndpoint)) {
                this.rmiServerMap.remove(clusterEndpoint);
                this.clusterInterface.getClusterPivot().removeClusterMember(clusterEndpoint);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Method method, Object[] args) throws Exception {
        ClusterEndpoint clusterEndpoint = null;
        Object[] pivotParameters = args == null ? new Object[1] : new Object[args.length + 1];
        pivotParameters[0] = method;
        if (args != null) {
            System.arraycopy(args, 0, pivotParameters, 1, args.length);
        }
        while (true) {
            RemoteClusterService remoteHandle;
            HashMap<ClusterEndpoint, RemoteClusterService> hashMap = this.rmiServerMap;
            synchronized (hashMap) {
                clusterEndpoint = this.clusterInterface.getClusterPivot().nextRequestAddress(pivotParameters, clusterEndpoint);
                if (clusterEndpoint == null) {
                    throw new ClusterManagementException("No server is currently available for requests to ClusterInterface (%s)", this.clusterInterface);
                }
                remoteHandle = this.rmiServerMap.get(clusterEndpoint);
            }
            if (remoteHandle != null) {
                try {
                    return remoteHandle.remoteInvocation(new InvocationSignal(ContextFactory.getExpectedContexts((Class)this.clusterInterface.getClusterProtocolDetails().getServiceInterface()), new FauxMethod(method), args));
                }
                catch (MissingInvocationException missingInvocationException) {
                    throw new ClusterManagementException("Could not invoke method (%s) on the remote cluster", method.getName());
                }
                catch (RemoteException remoteException) {
                    this.clusterHub.logError(remoteException);
                    this.removeClusterMember(clusterEndpoint);
                    continue;
                }
            }
            this.clusterHub.logError((Throwable)((Object)new ClusterManagementException("Pivot ClusterEndpoint/remote handle mismatch on cluster (%s)", clusterEndpoint)));
            this.removeClusterMember(clusterEndpoint);
        }
    }
}

