/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.cloud.service.messaging.spring;

import java.util.HashMap;
import java.util.List;
import javax.jms.JMSException;
import javax.naming.NamingException;
import org.smallmind.quorum.pool.connection.ConnectionPool;
import org.smallmind.quorum.pool.connection.ConnectionPoolException;
import org.smallmind.quorum.transport.messaging.MessagingConnectionDetails;
import org.smallmind.quorum.transport.messaging.MessagingTransmitter;
import org.smallmind.scribe.pen.LoggerManager;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class ServiceDispatcherInitializingBean
implements InitializingBean,
DisposableBean {
    private static final HashMap<String, MessagingTransmitter> MESSAGING_TRANSMITTER_MAP = new HashMap();
    private ConnectionPool javaEnvironmentPool;
    private List<String> serviceSelectorList;
    private String jmsUser;
    private String jmsCredentials;
    private String destinationEnvPath;
    private String factoryEnvPath;
    private boolean closed = false;
    private int transmissionPoolSize;

    public static MessagingTransmitter getMessagingTransmitter(String serviceSelector) {
        return MESSAGING_TRANSMITTER_MAP.get(serviceSelector);
    }

    public void setJmsUser(String jmsUser) {
        this.jmsUser = jmsUser;
    }

    public void setJmsCredentials(String jmsCredentials) {
        this.jmsCredentials = jmsCredentials;
    }

    public void setJavaEnvironmentPool(ConnectionPool javaEnvironmentPool) {
        this.javaEnvironmentPool = javaEnvironmentPool;
    }

    public void setDestinationEnvPath(String destinationEnvPath) {
        this.destinationEnvPath = destinationEnvPath;
    }

    public void setFactoryEnvPath(String factoryEnvPath) {
        this.factoryEnvPath = factoryEnvPath;
    }

    public void setTransmissionPoolSize(int transmissionPoolSize) {
        this.transmissionPoolSize = transmissionPoolSize;
    }

    public void setServiceSelectorList(List<String> serviceSelectorList) {
        this.serviceSelectorList = serviceSelectorList;
    }

    public void afterPropertiesSet() throws NoSuchMethodException, NamingException, JMSException, ConnectionPoolException {
        for (String serviceSelector : this.serviceSelectorList) {
            MessagingConnectionDetails connectionDetails = new MessagingConnectionDetails(this.javaEnvironmentPool, this.destinationEnvPath, this.factoryEnvPath, this.jmsUser, this.jmsCredentials, this.transmissionPoolSize, serviceSelector);
            MESSAGING_TRANSMITTER_MAP.put(serviceSelector, new MessagingTransmitter(connectionDetails));
        }
    }

    public synchronized void close() {
        if (!this.closed) {
            this.closed = true;
            for (MessagingTransmitter messagingTransmitter : MESSAGING_TRANSMITTER_MAP.values()) {
                try {
                    messagingTransmitter.close();
                }
                catch (JMSException jmsException) {
                    LoggerManager.getLogger(ServiceDispatcherInitializingBean.class).error((Throwable)jmsException);
                }
            }
        }
    }

    public void destroy() {
        this.close();
    }

    public void finalize() {
        this.close();
    }
}

