/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.cloud.service.messaging.spring;

import java.util.LinkedList;
import java.util.List;
import javax.jms.JMSException;
import javax.naming.NamingException;
import org.smallmind.cloud.service.messaging.ServiceEndpoint;
import org.smallmind.cloud.service.messaging.ServiceTarget;
import org.smallmind.quorum.pool.connection.ConnectionPool;
import org.smallmind.quorum.pool.connection.ConnectionPoolException;
import org.smallmind.quorum.transport.messaging.MessageTarget;
import org.smallmind.quorum.transport.messaging.MessagingConnectionDetails;
import org.smallmind.quorum.transport.messaging.MessagingReceiver;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class ServiceNegotiatorInitializingBean
implements InitializingBean,
DisposableBean {
    private final LinkedList<MessagingReceiver> messagingReceiverList = new LinkedList();
    private ConnectionPool javaEnvironmentPool;
    private List<ServiceEndpoint> serviceEndpointList;
    private String jmsUser;
    private String jmsCredentials;
    private String destinationEnvPath;
    private String factoryEnvPath;
    private boolean closed = false;

    public void setJmsUser(String jmsUser) {
        this.jmsUser = jmsUser;
    }

    public void setJmsCredentials(String jmsCredentials) {
        this.jmsCredentials = jmsCredentials;
    }

    public void setJavaEnvironmentPool(ConnectionPool javaEnvironmentPool) {
        this.javaEnvironmentPool = javaEnvironmentPool;
    }

    public void setDestinationEnvPath(String destinationEnvPath) {
        this.destinationEnvPath = destinationEnvPath;
    }

    public void setFactoryEnvPath(String factoryEnvPath) {
        this.factoryEnvPath = factoryEnvPath;
    }

    public void setServiceEndpointList(List<ServiceEndpoint> serviceEndpointList) {
        this.serviceEndpointList = serviceEndpointList;
    }

    public void afterPropertiesSet() throws NoSuchMethodException, NamingException, JMSException, ConnectionPoolException {
        for (ServiceEndpoint serviceEndpoint : this.serviceEndpointList) {
            MessagingConnectionDetails connectionDetails = new MessagingConnectionDetails(this.javaEnvironmentPool, this.destinationEnvPath, this.factoryEnvPath, this.jmsUser, this.jmsCredentials, 0, serviceEndpoint.getServiceSelector());
            this.messagingReceiverList.add(new MessagingReceiver((MessageTarget)new ServiceTarget(serviceEndpoint), connectionDetails));
        }
    }

    public synchronized void close() {
        if (!this.closed) {
            this.closed = true;
            for (MessagingReceiver messagingReceiver : this.messagingReceiverList) {
                messagingReceiver.close();
            }
        }
    }

    public void destroy() {
        this.close();
    }

    public void finalize() {
        this.close();
    }
}

