/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.cloud.cluster;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.smallmind.cloud.cluster.ClusterHub;
import org.smallmind.scribe.pen.LoggerManager;

public class ClusterUpdateTimer
implements Runnable {
    private CountDownLatch exitLatch;
    private CountDownLatch finishLatch;
    private ClusterHub clusterHub;
    private long pulseTime;

    public ClusterUpdateTimer(ClusterHub clusterHub, int updateInterval) {
        this.clusterHub = clusterHub;
        this.pulseTime = updateInterval * 1000;
        this.finishLatch = new CountDownLatch(1);
        this.exitLatch = new CountDownLatch(1);
    }

    public void finish() throws InterruptedException {
        this.finishLatch.countDown();
        this.exitLatch.await();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            do {
                this.clusterHub.fireStatusUpdate(this.clusterHub.getClientClusterInstances());
            } while (!this.finishLatch.await(this.pulseTime, TimeUnit.MILLISECONDS));
        }
        catch (InterruptedException interruptedException) {
            this.finishLatch.countDown();
            LoggerManager.getLogger(ClusterUpdateTimer.class).error((Throwable)interruptedException);
        }
        finally {
            this.exitLatch.countDown();
        }
    }
}

