/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.cloud.namespace.java.backingStore.ldap;

import java.util.Hashtable;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import org.smallmind.cloud.namespace.java.backingStore.ContextCreator;
import org.smallmind.cloud.namespace.java.backingStore.NamingConnectionDetails;

public class LdapContextCreator
extends ContextCreator {
    public static void insureContext(DirContext dirContext, String namingPath) throws NamingException {
        String[] pathArray = namingPath.split(",", -1);
        StringBuilder pathSoFar = new StringBuilder();
        for (int count = pathArray.length - 1; count >= 0; --count) {
            if (pathSoFar.length() > 0) {
                pathSoFar.insert(0, ',');
            }
            pathSoFar.insert(0, pathArray[count]);
            try {
                dirContext.lookup(pathSoFar.toString());
                continue;
            }
            catch (NameNotFoundException n) {
                dirContext.createSubcontext(pathSoFar.toString());
            }
        }
    }

    public LdapContextCreator(NamingConnectionDetails connectionDetails) {
        super(connectionDetails);
    }

    public String getRoot() {
        return this.getConnectionDetails().getRootNamespace();
    }

    @Override
    public DirContext getInitialContext() throws NamingException {
        DirContext rootLdapContext;
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", this.getConnectionDetails().getUserName());
        env.put("java.naming.security.credentials", this.getConnectionDetails().getPassword());
        InitialDirContext initLdapContext = new InitialDirContext(env);
        String rootUrl = "ldap://" + this.getConnectionDetails().getHost() + ":" + this.getConnectionDetails().getPort() + "/" + this.getConnectionDetails().getRootNamespace();
        try {
            rootLdapContext = (DirContext)initLdapContext.lookup(rootUrl);
        }
        catch (NamingException originalNamingException) {
            throw (NamingException)new NamingException(rootUrl).initCause(originalNamingException);
        }
        return rootLdapContext;
    }
}

