/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.cloud.namespace.java.pool;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.naming.NamingException;
import org.smallmind.cloud.namespace.java.PooledJavaContext;
import org.smallmind.cloud.namespace.java.event.JavaContextEvent;
import org.smallmind.cloud.namespace.java.event.JavaContextListener;
import org.smallmind.quorum.pool.connection.ConnectionInstance;
import org.smallmind.quorum.pool.connection.ConnectionPool;
import org.smallmind.scribe.pen.LoggerManager;

public class JavaContextConnectionInstance
implements ConnectionInstance<PooledJavaContext>,
JavaContextListener {
    private final ConnectionPool<PooledJavaContext> connectionPool;
    private final PooledJavaContext pooledJavaContext;
    private final AtomicReference<StackTraceElement[]> stackTraceReference = new AtomicReference();
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public JavaContextConnectionInstance(ConnectionPool<PooledJavaContext> connectionPool, PooledJavaContext pooledJavaContext) throws NamingException {
        this.connectionPool = connectionPool;
        this.pooledJavaContext = pooledJavaContext;
        pooledJavaContext.addJavaContextListener(this);
    }

    public StackTraceElement[] getExistentialStackTrace() {
        return this.stackTraceReference.get();
    }

    public boolean validate() {
        try {
            this.pooledJavaContext.lookup("");
        }
        catch (NamingException namingException) {
            return false;
        }
        return true;
    }

    @Override
    public void contextClosed(JavaContextEvent javaContextEvent) {
        try {
            this.connectionPool.returnInstance((ConnectionInstance)this);
        }
        catch (Exception exception) {
            LoggerManager.getLogger(JavaContextConnectionInstance.class).error((Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void contextAborted(JavaContextEvent javaContextEvent) {
        Exception reportedException = javaContextEvent.getCommunicationException();
        try {
            this.connectionPool.terminateInstance((ConnectionInstance)this);
        }
        catch (Exception exception) {
            if (reportedException != null && exception.getCause() == exception) {
                exception.initCause(reportedException);
            }
            reportedException = exception;
        }
        finally {
            if (reportedException != null) {
                this.connectionPool.reportConnectionErrorOccurred(reportedException);
                LoggerManager.getLogger(JavaContextConnectionInstance.class).error((Throwable)reportedException);
            }
        }
    }

    public PooledJavaContext serve() throws Exception {
        if (this.connectionPool.getConnectionPoolConfig().isExistentiallyAware()) {
            this.stackTraceReference.set(Thread.currentThread().getStackTrace());
        }
        return this.pooledJavaContext;
    }

    public void close() throws Exception {
        if (this.closed.compareAndSet(false, true)) {
            if (this.connectionPool.getConnectionPoolConfig().isExistentiallyAware()) {
                this.stackTraceReference.set(null);
            }
            if (this.pooledJavaContext != null) {
                this.pooledJavaContext.close(true);
            }
        }
    }
}

