/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.cloud.multicast;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.util.LinkedList;
import org.smallmind.cloud.multicast.DatagramBroadcastAgent;
import org.smallmind.cloud.multicast.MulticastBroadcastAgent;
import org.smallmind.scribe.pen.Logger;

public class PacketBroadcaster {
    private static final int SO_TIMEOUT = 1000;
    private static final int TTL = 128;
    private Logger logger;
    private DatagramSocket datagramSocket;
    private MulticastSocket multicastSocket;
    private DatagramBroadcastAgent datagramAgent;
    private MulticastBroadcastAgent multicastAgent;
    private InetAddress multicastInetAddress;
    private boolean finished = false;

    public PacketBroadcaster(Logger logger, String multicastIP, int multicastPort, String[] broadcastHosts, int broadcastPort, int messageSegmentSize) throws IOException {
        this.logger = logger;
        LinkedList<InetAddress> broadcastAddressList = new LinkedList<InetAddress>();
        for (String broadcastHost : broadcastHosts) {
            broadcastAddressList.add(InetAddress.getByName(broadcastHost));
        }
        broadcastAddressList.remove(InetAddress.getLocalHost());
        InetAddress[] broadcastInetAddresses = new InetAddress[broadcastAddressList.size()];
        broadcastAddressList.toArray(broadcastInetAddresses);
        this.multicastInetAddress = InetAddress.getByName(multicastIP);
        this.datagramSocket = new DatagramSocket(broadcastPort);
        this.datagramSocket.setReuseAddress(true);
        this.datagramSocket.setSoTimeout(1000);
        this.multicastSocket = new MulticastSocket(multicastPort);
        this.multicastSocket.setReuseAddress(true);
        this.multicastSocket.setSoTimeout(1000);
        this.multicastSocket.setTimeToLive(128);
        this.multicastSocket.joinGroup(this.multicastInetAddress);
        this.datagramAgent = new DatagramBroadcastAgent(this, this.datagramSocket, this.multicastSocket, this.multicastInetAddress, multicastPort, messageSegmentSize);
        this.multicastAgent = new MulticastBroadcastAgent(this, this.datagramSocket, this.multicastSocket, broadcastInetAddresses, broadcastPort, messageSegmentSize);
        Thread datagramAgentThread = new Thread(this.datagramAgent);
        Thread multicastAgentThread = new Thread(this.multicastAgent);
        datagramAgentThread.start();
        multicastAgentThread.start();
    }

    public String getComponentType() {
        return "multicast";
    }

    public void logError(Throwable throwable) {
        this.logger.error(throwable);
    }

    public synchronized void finish() {
        if (!this.finished) {
            try {
                this.multicastAgent.finish();
            }
            catch (InterruptedException interruptedException) {
                this.logger.error((Throwable)interruptedException);
            }
            try {
                this.datagramAgent.finish();
            }
            catch (InterruptedException interruptedException) {
                this.logger.error((Throwable)interruptedException);
            }
            try {
                this.multicastSocket.leaveGroup(this.multicastInetAddress);
                this.multicastSocket.close();
                this.datagramSocket.close();
            }
            catch (IOException ioException) {
                this.logError(ioException);
            }
        }
    }

    public void finalize() {
        this.finish();
    }
}

