/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.cloud.multicast.event;

import java.nio.ByteBuffer;
import org.smallmind.cloud.multicast.event.MessageStatus;
import org.smallmind.cloud.multicast.event.MessageType;
import org.smallmind.nutsnbolts.util.UniqueId;

public abstract class EventMessage {
    public static final int MESSAGE_HEADER_SIZE = UniqueId.byteSize() + 16;
    private ByteBuffer translationBuffer;

    public EventMessage(byte[] messageId, MessageType messageType, int messageLength, int extraSize) {
        byte[] messageArray = new byte[messageId.length + 12 + extraSize];
        this.translationBuffer = ByteBuffer.wrap(messageArray);
        this.translationBuffer.putInt(MessageStatus.MULTICAST.ordinal());
        this.translationBuffer.put(messageId);
        this.translationBuffer.putInt(messageType.ordinal());
        this.translationBuffer.putInt(messageLength);
    }

    public void put(byte[] b) {
        this.translationBuffer.put(b);
    }

    public void putInt(int i) {
        this.translationBuffer.putInt(i);
    }

    public void putLong(long l) {
        this.translationBuffer.putLong(l);
    }

    public ByteBuffer getByteBuffer() {
        return this.translationBuffer;
    }
}

