/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.cloud.namespace.java;

import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingException;
import org.smallmind.cloud.namespace.java.JavaName;
import org.smallmind.cloud.namespace.java.backingStore.NameTranslator;

public class JavaNameParser
implements NameParser {
    private NameTranslator nameTranslator;

    public JavaNameParser(NameTranslator nameTranslator) {
        this.nameTranslator = nameTranslator;
    }

    @Override
    public Name parse(String name) throws NamingException {
        JavaName parsedName = new JavaName(this.nameTranslator);
        if (name.equals("")) {
            return parsedName;
        }
        String[] parseArray = name.split("/", -1);
        for (int count = 0; count < parseArray.length; ++count) {
            if (count == 0) {
                int colonPos = parseArray[count].indexOf(":");
                if (colonPos >= 0) {
                    parsedName.add(parseArray[count].substring(0, colonPos + 1));
                    if (colonPos + 1 >= parseArray[count].length()) continue;
                    parsedName.add(parseArray[count].substring(colonPos + 1));
                    continue;
                }
                parsedName.add(parseArray[count]);
                continue;
            }
            parsedName.add(parseArray[count]);
        }
        return parsedName;
    }

    public String unparse(Name name) {
        if (name.size() == 0) {
            return "";
        }
        StringBuilder nameBuilder = new StringBuilder();
        for (int count = 0; count < name.size(); ++count) {
            if (count > 0) {
                nameBuilder.append('/');
            }
            nameBuilder.append(name.get(count));
        }
        return nameBuilder.toString();
    }
}

