/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.cloud.namespace.java.pool;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.naming.NamingException;
import org.smallmind.cloud.namespace.java.PooledJavaContext;
import org.smallmind.cloud.namespace.java.event.JavaContextEvent;
import org.smallmind.cloud.namespace.java.event.JavaContextListener;
import org.smallmind.quorum.pool.complex.ComponentInstance;
import org.smallmind.quorum.pool.complex.ComponentPool;
import org.smallmind.scribe.pen.LoggerManager;

public class JavaContextComponentInstance
implements ComponentInstance<PooledJavaContext>,
JavaContextListener {
    private final ComponentPool<PooledJavaContext> componentPool;
    private final PooledJavaContext pooledJavaContext;
    private final AtomicReference<StackTraceElement[]> stackTraceReference = new AtomicReference();
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public JavaContextComponentInstance(ComponentPool<PooledJavaContext> componentPool, PooledJavaContext pooledJavaContext) throws NamingException {
        this.componentPool = componentPool;
        this.pooledJavaContext = pooledJavaContext;
        pooledJavaContext.addJavaContextListener(this);
    }

    public StackTraceElement[] getExistentialStackTrace() {
        return this.stackTraceReference.get();
    }

    public boolean validate() {
        try {
            this.pooledJavaContext.lookup("");
        }
        catch (NamingException namingException) {
            return false;
        }
        return true;
    }

    @Override
    public void contextClosed(JavaContextEvent javaContextEvent) {
        try {
            this.componentPool.returnInstance((ComponentInstance)this);
        }
        catch (Exception exception) {
            LoggerManager.getLogger(JavaContextComponentInstance.class).error((Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void contextAborted(JavaContextEvent javaContextEvent) {
        Exception reportedException = javaContextEvent.getCommunicationException();
        try {
            this.componentPool.terminateInstance((ComponentInstance)this);
        }
        catch (Exception exception) {
            if (reportedException != null && exception.getCause() == exception) {
                exception.initCause(reportedException);
            }
            reportedException = exception;
        }
        finally {
            if (reportedException != null) {
                this.componentPool.reportErrorOccurred(reportedException);
                LoggerManager.getLogger(JavaContextComponentInstance.class).error((Throwable)reportedException);
            }
        }
    }

    public PooledJavaContext serve() throws Exception {
        if (this.componentPool.getComplexPoolConfig().isExistentiallyAware()) {
            this.stackTraceReference.set(Thread.currentThread().getStackTrace());
        }
        return this.pooledJavaContext;
    }

    public void close() throws Exception {
        if (this.closed.compareAndSet(false, true)) {
            if (this.componentPool.getComplexPoolConfig().isExistentiallyAware()) {
                this.stackTraceReference.set(null);
            }
            if (this.pooledJavaContext != null) {
                this.pooledJavaContext.close(true);
            }
        }
    }
}

