/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.cloud.multicast;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import org.smallmind.cloud.multicast.PacketBroadcaster;
import org.smallmind.cloud.multicast.event.EventMessage;
import org.smallmind.cloud.multicast.event.MessageStatus;

public class MulticastBroadcastAgent
implements Runnable {
    private CountDownLatch exitLatch;
    private PacketBroadcaster packetBroadcaster;
    private MulticastSocket multicastSocket;
    private DatagramSocket datagramSocket;
    private InetAddress[] broadcastInetAddresses;
    private boolean finished = false;
    private int broadcastPort;
    private int messageBufferSize;

    public MulticastBroadcastAgent(PacketBroadcaster packetBroadcaster, DatagramSocket datagramSocket, MulticastSocket multicastSocket, InetAddress[] broadcastInetAddresses, int broadcastPort, int messageSegmentSize) {
        this.packetBroadcaster = packetBroadcaster;
        this.datagramSocket = datagramSocket;
        this.multicastSocket = multicastSocket;
        this.broadcastInetAddresses = broadcastInetAddresses;
        this.broadcastPort = broadcastPort;
        this.messageBufferSize = messageSegmentSize + EventMessage.MESSAGE_HEADER_SIZE;
        this.exitLatch = new CountDownLatch(1);
    }

    public synchronized void finish() throws InterruptedException {
        this.finished = true;
        this.exitLatch.await();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        byte[] messageBuffer = new byte[this.messageBufferSize];
        ByteBuffer translationBuffer = ByteBuffer.wrap(messageBuffer);
        DatagramPacket messagePacket = new DatagramPacket(messageBuffer, messageBuffer.length);
        try {
            while (!this.finished) {
                try {
                    MessageStatus messageStatus;
                    boolean packetReceived;
                    try {
                        this.multicastSocket.receive(messagePacket);
                        packetReceived = true;
                    }
                    catch (SocketTimeoutException s) {
                        packetReceived = false;
                    }
                    if (!packetReceived || (messageStatus = MessageStatus.getMessageStatus(translationBuffer.getInt(0))).equals((Object)MessageStatus.BROADCAST)) continue;
                    messagePacket.setPort(this.broadcastPort);
                    for (InetAddress broadcastAddress : this.broadcastInetAddresses) {
                        messagePacket.setAddress(broadcastAddress);
                        this.datagramSocket.send(messagePacket);
                    }
                }
                catch (Exception e) {
                    this.packetBroadcaster.logError(e);
                }
            }
            return;
        }
        finally {
            this.exitLatch.countDown();
        }
    }
}

