/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.cloud.multicast.event;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.smallmind.cloud.multicast.EventMessageException;
import org.smallmind.cloud.multicast.event.EventMessage;
import org.smallmind.cloud.multicast.event.EventMessageBody;
import org.smallmind.cloud.multicast.event.EventMessageHeader;
import org.smallmind.cloud.multicast.event.EventMessageKey;
import org.smallmind.cloud.multicast.event.EventMessageMold;
import org.smallmind.cloud.multicast.event.MessageType;
import org.smallmind.cloud.multicast.event.MulticastEvent;
import org.smallmind.cloud.multicast.event.MulticastEventHandler;
import org.smallmind.nutsnbolts.lang.UnknownSwitchCaseException;
import org.smallmind.nutsnbolts.util.SelfDestructive;
import org.smallmind.nutsnbolts.util.SelfDestructiveMap;
import org.smallmind.nutsnbolts.util.UniqueId;
import org.smallmind.scribe.pen.Logger;

public class EventTransmitter
implements Runnable {
    private static final int SO_TIMEOUT = 1000;
    private static final int TTL = 3;
    private static final byte[] EMPTY_ID = new byte[UniqueId.byteSize()];
    private Logger logger;
    private CountDownLatch exitLatch;
    private AtomicBoolean finished = new AtomicBoolean(false);
    private SelfDestructiveMap<EventMessageKey, EventMessageMold> messageCache;
    private MulticastEventHandler eventHandler;
    private MulticastSocket multicastSocket;
    private InetAddress multicastInetAddr;
    private int multicastPort;
    private int messageSegmentSize;
    private int messageBufferSize;

    public EventTransmitter(MulticastEventHandler eventHandler, Logger logger, InetAddress multicastInetAddr, int multicastPort, int messageSegmentSize) throws Exception {
        this.eventHandler = eventHandler;
        this.logger = logger;
        this.multicastInetAddr = multicastInetAddr;
        this.multicastPort = multicastPort;
        this.messageSegmentSize = messageSegmentSize;
        this.messageBufferSize = messageSegmentSize + EventMessage.MESSAGE_HEADER_SIZE;
        this.messageCache = new SelfDestructiveMap(60, 3);
        this.multicastSocket = new MulticastSocket(multicastPort);
        this.multicastSocket.setReuseAddress(true);
        this.multicastSocket.setSoTimeout(1000);
        this.multicastSocket.setTimeToLive(3);
        this.multicastSocket.joinGroup(multicastInetAddr);
        this.exitLatch = new CountDownLatch(1);
        Thread receiverThread = new Thread(this);
        receiverThread.setDaemon(true);
        receiverThread.start();
    }

    public synchronized void fireEvent(MulticastEvent multicastEvent) throws EventMessageException {
        try {
            byte[] bodyBuffer = this.objectToByteArray(multicastEvent);
            byte[] messageId = multicastEvent != null ? UniqueId.newInstance().asByteArray() : EMPTY_ID;
            EventMessageHeader messageHeader = new EventMessageHeader(messageId, bodyBuffer.length);
            this.sendDatagram(messageHeader.getByteBuffer());
            this.sendBody(messageId, bodyBuffer);
        }
        catch (Exception e) {
            throw new EventMessageException(e);
        }
    }

    private byte[] objectToByteArray(Object body) throws IOException {
        byte[] bodyBuffer;
        if (body != null) {
            ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteOutputStream);
            objectOutputStream.writeObject(body);
            objectOutputStream.close();
            bodyBuffer = byteOutputStream.toByteArray();
        } else {
            bodyBuffer = new byte[]{};
        }
        return bodyBuffer;
    }

    private void sendBody(byte[] messageId, byte[] bodyBuffer) throws IOException {
        int bytesToSend;
        int messageIndex = 0;
        for (int bufferPos = 0; bufferPos < bodyBuffer.length; bufferPos += bytesToSend) {
            bytesToSend = Math.min(this.messageSegmentSize, bodyBuffer.length - bufferPos);
            byte[] bodySegment = new byte[bytesToSend];
            System.arraycopy(bodyBuffer, bufferPos, bodySegment, 0, bytesToSend);
            EventMessageBody messageBody = new EventMessageBody(messageId, messageIndex++, bodySegment);
            this.sendDatagram(messageBody.getByteBuffer());
        }
    }

    private void sendDatagram(ByteBuffer dataBuffer) throws IOException {
        dataBuffer.flip();
        this.multicastSocket.send(new DatagramPacket(dataBuffer.array(), dataBuffer.position(), dataBuffer.limit() - dataBuffer.position(), this.multicastInetAddr, this.multicastPort));
    }

    public void logError(Throwable throwable) {
        this.logger.error(throwable);
    }

    public synchronized void finish() {
        if (this.finished.compareAndSet(false, true)) {
            try {
                this.exitLatch.await();
            }
            catch (InterruptedException interruptedException) {
                this.logError(interruptedException);
            }
            try {
                this.multicastSocket.leaveGroup(this.multicastInetAddr);
                this.multicastSocket.close();
            }
            catch (IOException ioException) {
                this.logError(ioException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        byte[] messageKeyBuffer = new byte[UniqueId.byteSize()];
        byte[] messageBuffer = new byte[this.messageBufferSize];
        ByteBuffer translationBuffer = ByteBuffer.wrap(messageBuffer);
        DatagramPacket messagePacket = new DatagramPacket(messageBuffer, messageBuffer.length);
        try {
            while (!this.finished.get()) {
                try {
                    EventMessageMold prevMessageMold;
                    boolean packetReceived;
                    try {
                        this.multicastSocket.receive(messagePacket);
                        packetReceived = true;
                    }
                    catch (SocketTimeoutException s) {
                        packetReceived = false;
                    }
                    if (!packetReceived) continue;
                    translationBuffer.rewind();
                    translationBuffer.getInt();
                    translationBuffer.get(messageKeyBuffer);
                    EventMessageKey messageKey = new EventMessageKey(messageKeyBuffer);
                    MessageType messageType = MessageType.getMessageType(translationBuffer.getInt());
                    int messageLength = translationBuffer.getInt();
                    EventMessageMold messageMold = (EventMessageMold)this.messageCache.get((Comparable)messageKey);
                    if (messageMold == null && (prevMessageMold = (EventMessageMold)this.messageCache.putIfAbsent((Comparable)messageKey, (SelfDestructive)new EventMessageMold())) != null) {
                        messageMold = prevMessageMold;
                    }
                    switch (messageType) {
                        case HEADER: {
                            messageMold.setMessageLength(messageLength);
                            break;
                        }
                        case DATA: {
                            int messageIndex = translationBuffer.getInt();
                            byte[] messageSegment = new byte[messageLength];
                            translationBuffer.get(messageSegment);
                            messageMold.addData(messageIndex, messageSegment);
                            break;
                        }
                        default: {
                            throw new UnknownSwitchCaseException(messageType.name(), new Object[0]);
                        }
                    }
                    if (!messageMold.isComplete()) continue;
                    MulticastEvent multicastEvent = (MulticastEvent)messageMold.unmoldMessageBody();
                    this.eventHandler.deliverEvent(multicastEvent);
                }
                catch (Exception e) {
                    this.logger.error((Throwable)e);
                }
            }
            return;
        }
        finally {
            this.exitLatch.countDown();
        }
    }

    public void finalize() {
        this.finish();
    }

    static {
        Arrays.fill(EMPTY_ID, (byte)0);
    }
}

