/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.cloud.namespace.java.pool;

import java.util.Hashtable;
import javax.naming.InitialContext;
import org.smallmind.cloud.namespace.java.PooledJavaContext;
import org.smallmind.cloud.namespace.java.backingStore.NamingConnectionDetails;
import org.smallmind.cloud.namespace.java.backingStore.StorageType;
import org.smallmind.cloud.namespace.java.pool.JavaContextComponentInstance;
import org.smallmind.quorum.pool.complex.AbstractComponentInstanceFactory;
import org.smallmind.quorum.pool.complex.ComponentInstance;
import org.smallmind.quorum.pool.complex.ComponentPool;

public class PooledJavaContextComponentInstanceFactory
extends AbstractComponentInstanceFactory<PooledJavaContext> {
    private StorageType storageType;
    private String contextPath;
    private String host;
    private String rootNamespace;
    private String userContext;
    private String password;
    private boolean tls;
    private int port;

    public PooledJavaContextComponentInstanceFactory(StorageType storageType, String contextPath, String host, int port, boolean tls, String rootNamespace, String userContext, String password) {
        this.storageType = storageType;
        this.contextPath = contextPath;
        this.host = host;
        this.port = port;
        this.tls = tls;
        this.rootNamespace = rootNamespace;
        this.userContext = userContext;
        this.password = password;
    }

    public ComponentInstance<PooledJavaContext> createInstance(ComponentPool<PooledJavaContext> componentPool) throws Exception {
        Hashtable<String, Object> env = new Hashtable<String, Object>();
        env.put("java.naming.factory.url.pkgs", "org.smallmind.cloud.namespace");
        env.put("org.smallmind.cloud.namespace.java.connection details", new NamingConnectionDetails(this.host, this.port, this.tls, this.rootNamespace, this.userContext, this.password));
        env.put("org.smallmind.cloud.namespace.java.store", this.storageType.getBackingStore());
        env.put("org.smallmind.cloud.namespace.java.modifiable", "true");
        env.put("org.smallmind.cloud.namespace.java.pooled", "true");
        InitialContext initContext = new InitialContext(env);
        PooledJavaContext pooledJavaContext = (PooledJavaContext)initContext.lookup(this.contextPath);
        initContext.close();
        return new JavaContextComponentInstance(componentPool, pooledJavaContext);
    }
}

