/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.constellation.component;

import java.net.UnknownHostException;
import org.smallmind.cloud.cluster.ClusterEntity;
import org.smallmind.cloud.cluster.ClusterHub;
import org.smallmind.cloud.cluster.ClusterMember;
import org.smallmind.cloud.cluster.broadcast.GossipClusterBroadcast;
import org.smallmind.cloud.multicast.EventMessageException;
import org.smallmind.cloud.multicast.event.MulticastEvent;
import org.smallmind.constellation.component.SmallMindComponent;
import org.smallmind.quorum.pool.connection.ConnectionPool;

public abstract class SmallMindContainer
extends SmallMindComponent
implements ClusterMember {
    private ClusterHub clusterHub;
    private ClusterEntity clusterEntity;
    private String globalPath;
    private String localPath;

    public SmallMindContainer(ClusterHub clusterHub, ClusterEntity clusterEntity, ConnectionPool contextPool) throws UnknownHostException {
        super(contextPool);
        this.clusterHub = clusterHub;
        this.clusterEntity = clusterEntity;
        this.globalPath = "container/" + clusterEntity.getClusterName() + "/global";
        this.localPath = "container/" + clusterEntity.getClusterName() + "/local/" + this.getHostName() + "/" + clusterEntity.getInstanceId();
    }

    public abstract void startUp() throws Exception;

    public abstract void shutDown() throws Exception;

    public ClusterEntity getClusterEntity() {
        return this.clusterEntity;
    }

    @Override
    public String getGlobalNamespacePath() {
        return this.globalPath;
    }

    @Override
    public String getLocalNamespacePath() {
        return this.localPath;
    }

    public void fireGossipBroadcast(GossipClusterBroadcast gossipClusterBroadcast) throws EventMessageException {
        this.clusterHub.fireEvent((MulticastEvent)gossipClusterBroadcast);
    }
}

