/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.constellation.component;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.naming.Binding;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchResult;
import org.smallmind.nutsnbolts.naming.ContextUtilities;
import org.smallmind.quorum.pool.connection.ConnectionPool;
import org.smallmind.quorum.pool.connection.ConnectionPoolException;
import org.smallmind.scribe.pen.Logger;

public abstract class SmallMindComponent {
    private final LinkedList<String> namespaceContextList;
    private ConnectionPool contextPool;
    private InetAddress hostAddress;
    private String hostName;

    public SmallMindComponent(ConnectionPool contextPool) throws UnknownHostException {
        this.contextPool = contextPool;
        this.hostAddress = InetAddress.getLocalHost();
        this.hostName = this.hostAddress.getCanonicalHostName();
        this.namespaceContextList = new LinkedList();
    }

    public abstract String getComponentType();

    public abstract Logger getLogger();

    public abstract String getGlobalNamespacePath();

    public abstract String getLocalNamespacePath();

    public InetAddress getHostAddress() {
        return this.hostAddress;
    }

    public String getHostName() {
        return this.hostName;
    }

    private String completeNamespacePath(String basePath, String storageSubpath) {
        StringBuilder pathBuilder = new StringBuilder();
        pathBuilder.append("data/");
        pathBuilder.append(this.getComponentType());
        pathBuilder.append('/');
        pathBuilder.append(basePath);
        pathBuilder.append('/');
        pathBuilder.append(storageSubpath);
        return pathBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insureNamespaceContext(DirContext smallmindEnvironment, String completePath) throws NamingException {
        LinkedList<String> linkedList = this.namespaceContextList;
        synchronized (linkedList) {
            if (!this.namespaceContextList.contains(completePath)) {
                ContextUtilities.ensureContext((DirContext)smallmindEnvironment, (String)completePath);
                this.namespaceContextList.add(completePath);
            }
        }
    }

    public void removeGlobalNamespaceContext(String storageSubpath) throws ConnectionPoolException, NamingException {
        this.removeNamespaceContext(this.getGlobalNamespacePath(), storageSubpath);
    }

    public void removeLocalNamespaceContext(String storageSubpath) throws ConnectionPoolException, NamingException {
        this.removeNamespaceContext(this.getLocalNamespacePath(), storageSubpath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeNamespaceContext(String basePath, String storageSubpath) throws ConnectionPoolException, NamingException {
        String completePath = this.completeNamespacePath(basePath, storageSubpath);
        LinkedList<String> linkedList = this.namespaceContextList;
        synchronized (linkedList) {
            DirContext smallmindEnvironment = (DirContext)this.contextPool.getConnection();
            try {
                smallmindEnvironment.destroySubcontext(completePath);
                this.namespaceContextList.remove(completePath);
            }
            finally {
                smallmindEnvironment.close();
            }
        }
    }

    public void setGlobalData(String storageSubpath, Object data) throws ConnectionPoolException, NamingException {
        this.setData(this.getGlobalNamespacePath(), storageSubpath, data);
    }

    public void setLocalData(String storageSubpath, Object data) throws ConnectionPoolException, NamingException {
        this.setData(this.getLocalNamespacePath(), storageSubpath, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setData(String basePath, String storageSubpath, Object data) throws ConnectionPoolException, NamingException {
        if (data == null) {
            throw new IllegalArgumentException("Object data for storage must not be 'null'");
        }
        String completePath = this.completeNamespacePath(basePath, storageSubpath);
        DirContext smallmindEnvironment = (DirContext)this.contextPool.getConnection();
        try {
            this.insureNamespaceContext(smallmindEnvironment, completePath);
            smallmindEnvironment.rebind(completePath, data);
        }
        finally {
            smallmindEnvironment.close();
        }
    }

    public Object getGlobalData(String storageSubpath) throws ConnectionPoolException, NamingException {
        return this.getData(this.getGlobalNamespacePath(), storageSubpath);
    }

    public Object getLocalData(String storageSubpath) throws ConnectionPoolException, NamingException {
        return this.getData(this.getLocalNamespacePath(), storageSubpath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getData(String basePath, String storageSubpath) throws ConnectionPoolException, NamingException {
        Object data;
        DirContext smallmindEnvironment = (DirContext)this.contextPool.getConnection();
        try {
            data = smallmindEnvironment.lookup(this.completeNamespacePath(basePath, storageSubpath));
        }
        catch (NameNotFoundException n) {
            Object var6_6 = null;
            return var6_6;
        }
        finally {
            smallmindEnvironment.close();
        }
        return data;
    }

    public NamingEnumeration<NameClassPair> getGlobalList(String storageSubpath) throws ConnectionPoolException, NamingException {
        return this.getList(this.getGlobalNamespacePath(), storageSubpath);
    }

    public NamingEnumeration<NameClassPair> getLocalList(String storageSubpath) throws ConnectionPoolException, NamingException {
        return this.getList(this.getLocalNamespacePath(), storageSubpath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NamingEnumeration<NameClassPair> getList(String basePath, String storageSubpath) throws ConnectionPoolException, NamingException {
        DirContext smallmindEnvironment = (DirContext)this.contextPool.getConnection();
        try {
            NamingEnumeration<NameClassPair> namingEnumeration = smallmindEnvironment.list(this.completeNamespacePath(basePath, storageSubpath));
            return namingEnumeration;
        }
        finally {
            smallmindEnvironment.close();
        }
    }

    public void removeGlobalData(String storageSubpath) throws ConnectionPoolException, NamingException {
        this.removeData(this.getGlobalNamespacePath(), storageSubpath);
    }

    public void removeLocalData(String storageSubpath) throws ConnectionPoolException, NamingException {
        this.removeData(this.getLocalNamespacePath(), storageSubpath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeData(String basePath, String storageSubpath) throws ConnectionPoolException, NamingException {
        DirContext smallmindEnvironment = (DirContext)this.contextPool.getConnection();
        try {
            smallmindEnvironment.unbind(this.completeNamespacePath(basePath, storageSubpath));
        }
        finally {
            smallmindEnvironment.close();
        }
    }

    public Map<String, Object> getGlobalDataMap(String storageSubpath) throws ConnectionPoolException, NamingException {
        return this.getDataMap(this.getGlobalNamespacePath(), storageSubpath);
    }

    public Map<String, Object> getLocalDataMap(String storageSubpath) throws ConnectionPoolException, NamingException {
        return this.getDataMap(this.getLocalNamespacePath(), storageSubpath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> getDataMap(String basePath, String storageSubpath) throws ConnectionPoolException, NamingException {
        HashMap<String, Object> bindingMap = new HashMap<String, Object>();
        DirContext smallmindEnvironment = (DirContext)this.contextPool.getConnection();
        try {
            NamingEnumeration<Binding> bindingEnum = smallmindEnvironment.listBindings(this.completeNamespacePath(basePath, storageSubpath));
            while (bindingEnum.hasMore()) {
                Binding binding = bindingEnum.next();
                bindingMap.put(binding.getName(), binding.getObject());
            }
        }
        finally {
            smallmindEnvironment.close();
        }
        return bindingMap;
    }

    public Attributes getGlobalAttributes(String storageSubpath, String[] returnAttributeArray) throws ConnectionPoolException, NamingException {
        return this.getAttributes(this.getGlobalNamespacePath(), storageSubpath, returnAttributeArray);
    }

    public Attributes getLocalAttributes(String storageSubpath, String[] returnAttributeArray) throws ConnectionPoolException, NamingException {
        return this.getAttributes(this.getLocalNamespacePath(), storageSubpath, returnAttributeArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Attributes getAttributes(String basePath, String storageSubpath, String[] returnAttributeArray) throws ConnectionPoolException, NamingException {
        DirContext smallmindEnvironment = (DirContext)this.contextPool.getConnection();
        try {
            Attributes attributes = smallmindEnvironment.getAttributes(this.completeNamespacePath(basePath, storageSubpath), returnAttributeArray);
            return attributes;
        }
        finally {
            smallmindEnvironment.close();
        }
    }

    public void modifyGlobalAttributes(String storageSubpath, ModificationItem[] modItems) throws ConnectionPoolException, NamingException {
        this.modifyAttributes(this.getGlobalNamespacePath(), storageSubpath, modItems);
    }

    public void modifyLocalAttributes(String storageSubpath, ModificationItem[] modItems) throws ConnectionPoolException, NamingException {
        this.modifyAttributes(this.getLocalNamespacePath(), storageSubpath, modItems);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void modifyAttributes(String basePath, String storageSubpath, ModificationItem[] modItems) throws ConnectionPoolException, NamingException {
        String completePath = this.completeNamespacePath(basePath, storageSubpath);
        DirContext smallmindEnvironment = (DirContext)this.contextPool.getConnection();
        try {
            this.insureNamespaceContext(smallmindEnvironment, completePath);
            smallmindEnvironment.modifyAttributes(completePath, modItems);
        }
        finally {
            smallmindEnvironment.close();
        }
    }

    public List<Attributes> searchGlobalAttributes(String storageSubpath, Attributes searchAttributes, String[] returnAttributeArray) throws ConnectionPoolException, NamingException {
        return this.searchAttributes(this.getGlobalNamespacePath(), storageSubpath, searchAttributes, returnAttributeArray);
    }

    public List<Attributes> searchLocalAttributes(String storageSubpath, Attributes searchAttributes, String[] returnAttributeArray) throws ConnectionPoolException, NamingException {
        return this.searchAttributes(this.getLocalNamespacePath(), storageSubpath, searchAttributes, returnAttributeArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Attributes> searchAttributes(String basePath, String storageSubpath, Attributes searchAttributes, String[] returnAttributeArray) throws ConnectionPoolException, NamingException {
        String completePath = this.completeNamespacePath(basePath, storageSubpath);
        LinkedList<Attributes> resultList = new LinkedList<Attributes>();
        DirContext smallmindEnvironment = (DirContext)this.contextPool.getConnection();
        try {
            this.insureNamespaceContext(smallmindEnvironment, completePath);
            NamingEnumeration<SearchResult> searchEnum = smallmindEnvironment.search(this.completeNamespacePath(basePath, storageSubpath), searchAttributes, returnAttributeArray);
            while (searchEnum.hasMore()) {
                resultList.add(searchEnum.next().getAttributes());
            }
        }
        finally {
            smallmindEnvironment.close();
        }
        return resultList;
    }

    public void logInfo(String message, Object ... args) {
        this.getLogger().info(message, args);
    }

    public void logWarning(Throwable throwable, String message, Object ... args) {
        this.getLogger().warn(throwable, message, args);
    }

    public void logError(String message, Object ... args) {
        this.getLogger().error(message, args);
    }

    public void logError(Throwable throwable, String message, Object ... args) {
        this.getLogger().error(throwable, message, args);
    }

    public void logError(Throwable throwable) {
        this.getLogger().error(throwable);
    }
}

