/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.constellation.ephemeral;

import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.Map;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.ModificationItem;
import org.smallmind.constellation.component.SmallMindComponent;
import org.smallmind.constellation.ephemeral.Ephemeral;
import org.smallmind.constellation.ephemeral.EphemeralCreationException;
import org.smallmind.constellation.ephemeral.EphemeralKey;
import org.smallmind.constellation.ephemeral.EphemeralPersistenceException;
import org.smallmind.constellation.ephemeral.EphemeralRecoveryException;
import org.smallmind.scribe.pen.Logger;

public class EphemeralHandle {
    private static final int ALL_ATTRIBUTES = 0;
    private static final int CLASS_NAME = 2;
    private static final int CREATION_TIME = 4;
    private static final int LAST_ACCESS_TIME = 8;
    private static final int TIMEOUT = 16;
    private static final int VALIDITY = 32;
    private SmallMindComponent smallMindComponent;
    private Logger logger;
    private EphemeralKey ephemeralKey;
    private WeakReference<Ephemeral> weakReference;
    private Class ephemeralClass;
    private String ephemeralClassName;
    private boolean validity;
    private boolean isNew;
    private long creationTime;
    private long lastAccessTime;
    private int timeout;

    public EphemeralHandle(SmallMindComponent smallMindComponent, Logger logger, EphemeralKey ephemeralKey, String ephemeralClassName, int creationTimeout) throws EphemeralCreationException {
        this.smallMindComponent = smallMindComponent;
        this.logger = logger;
        this.ephemeralKey = ephemeralKey;
        this.ephemeralClassName = ephemeralClassName;
        this.lastAccessTime = this.creationTime = System.currentTimeMillis();
        this.timeout = creationTimeout;
        this.validity = true;
        this.isNew = true;
        try {
            this.ephemeralClass = Class.forName(ephemeralClassName);
            this.cache(0);
        }
        catch (Exception e) {
            throw new EphemeralCreationException(e);
        }
    }

    public EphemeralHandle(SmallMindComponent smallMindComponent, Logger logger, EphemeralKey ephemeralKey, String ephemeralClassName, Long resultCreationTime, Long resultLastAccessTime, Integer resultTimeout, Boolean resultValidity) throws EphemeralCreationException {
        this.smallMindComponent = smallMindComponent;
        this.logger = logger;
        this.ephemeralKey = ephemeralKey;
        this.ephemeralClassName = ephemeralClassName;
        this.creationTime = resultCreationTime;
        this.lastAccessTime = resultLastAccessTime;
        this.timeout = resultTimeout;
        this.validity = resultValidity;
        this.isNew = false;
        try {
            this.ephemeralClass = Class.forName(ephemeralClassName);
        }
        catch (Exception e) {
            throw new EphemeralCreationException(e);
        }
    }

    private Ephemeral constructEphemeral(Class ephemeralClass, Class<EphemeralHandle> parameterClass, Object parameterValue) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class[] paramClasses = new Class[1];
        Object[] paramValues = new Object[1];
        paramClasses[0] = parameterClass;
        paramValues[0] = parameterValue;
        Constructor constructor = ephemeralClass.getConstructor(paramClasses);
        return (Ephemeral)constructor.newInstance(paramValues);
    }

    public synchronized Ephemeral getEphemeral() throws EphemeralRecoveryException {
        Ephemeral ephemeral;
        if (this.weakReference != null && (ephemeral = (Ephemeral)this.weakReference.get()) != null) {
            return ephemeral;
        }
        try {
            ephemeral = this.constructEphemeral(this.ephemeralClass, EphemeralHandle.class, this).postRevival();
            if (ephemeral != null) {
                this.weakReference = new WeakReference<Ephemeral>(ephemeral);
                return ephemeral;
            }
            return null;
        }
        catch (Exception e) {
            throw new EphemeralRecoveryException(e);
        }
    }

    public synchronized void clear() {
        this.weakReference.clear();
    }

    public synchronized void remove() {
        this.weakReference.clear();
        try {
            NamingEnumeration<NameClassPair> dataKeyEnum = this.smallMindComponent.getGlobalList("ephemeral/" + this.ephemeralKey.getEphemeralId());
            while (dataKeyEnum.hasMore()) {
                NameClassPair nameClassPair = dataKeyEnum.next();
                this.smallMindComponent.removeGlobalNamespaceContext("ephemeral/" + this.ephemeralKey.getEphemeralId() + "/" + nameClassPair.getName());
            }
            this.smallMindComponent.removeGlobalNamespaceContext("ephemeral/" + this.ephemeralKey.getEphemeralId());
        }
        catch (Exception e) {
            this.logError(e);
        }
    }

    public synchronized boolean isValid() {
        return this.validity;
    }

    public synchronized void invalidate(boolean cache) {
        if (this.validity) {
            try {
                Ephemeral ephemeral = this.getEphemeral();
                if (ephemeral != null) {
                    ephemeral.postInvalidation();
                }
            }
            catch (Exception e) {
                this.logError(e);
            }
            if (cache) {
                try {
                    this.cache(32);
                }
                catch (EphemeralPersistenceException p) {
                    this.logError((Exception)((Object)p));
                }
            }
            this.validity = false;
        }
    }

    public synchronized void touch() {
        this.lastAccessTime = System.currentTimeMillis();
        try {
            this.cache(8);
        }
        catch (EphemeralPersistenceException p) {
            this.logError((Exception)((Object)p));
        }
    }

    public synchronized long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public synchronized void setTimeout(int seconds) {
        this.timeout = seconds;
        try {
            this.cache(16);
        }
        catch (EphemeralPersistenceException p) {
            this.logError((Exception)((Object)p));
        }
    }

    public synchronized int getTimeout() {
        return this.timeout;
    }

    public synchronized boolean isNew() {
        return this.isNew;
    }

    public EphemeralKey getEphemeralKey() {
        return this.ephemeralKey;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public synchronized void bind(String key, Object data) {
        try {
            this.smallMindComponent.setGlobalData("ephemeral/" + this.ephemeralKey.getEphemeralId() + "/" + key, data);
        }
        catch (Exception e) {
            this.logError(e);
        }
    }

    public synchronized void unbind(String key) {
        try {
            this.smallMindComponent.removeGlobalData("ephemeral/" + this.ephemeralKey.getEphemeralId() + "/" + key);
        }
        catch (Exception e) {
            this.logError(e);
        }
    }

    public synchronized Map<String, Object> getBindings() throws EphemeralPersistenceException {
        try {
            return this.smallMindComponent.getGlobalDataMap("ephemeral/" + this.ephemeralKey.getEphemeralId());
        }
        catch (Exception e) {
            throw new EphemeralPersistenceException(e);
        }
    }

    private void cache(int filter) throws EphemeralPersistenceException {
        if (this.validity) {
            LinkedList<ModificationItem> modList = new LinkedList<ModificationItem>();
            if (filter == 0) {
                BasicAttribute objectClass = new BasicAttribute("objectclass");
                objectClass.add("top");
                objectClass.add("extensibleObject");
                modList.add(new ModificationItem(2, objectClass));
            }
            if (filter == 0 || (filter & 2) != 0) {
                modList.add(new ModificationItem(2, new BasicAttribute("classname", this.ephemeralClassName)));
            }
            if (filter == 0 || (filter & 4) != 0) {
                modList.add(new ModificationItem(2, new BasicAttribute("creationtime", String.valueOf(this.creationTime))));
            }
            if (filter == 0 || (filter & 8) != 0) {
                modList.add(new ModificationItem(2, new BasicAttribute("lastaccesstime", String.valueOf(this.lastAccessTime))));
            }
            if (filter == 0 || (filter & 0x10) != 0) {
                modList.add(new ModificationItem(2, new BasicAttribute("timeout", String.valueOf(this.timeout))));
            }
            if (filter == 0 || (filter & 0x20) != 0) {
                modList.add(new ModificationItem(2, new BasicAttribute("validity", String.valueOf(this.validity))));
            }
            ModificationItem[] modItems = new ModificationItem[modList.size()];
            modList.toArray(modItems);
            try {
                this.smallMindComponent.modifyGlobalAttributes("ephemeral/" + this.ephemeralKey.getEphemeralId(), modItems);
            }
            catch (Exception e) {
                throw new EphemeralPersistenceException(e);
            }
        }
    }

    public void logError(Exception exception) {
        this.logger.error((Throwable)exception);
    }
}

