/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.instrument;

import java.util.concurrent.TimeUnit;
import org.smallmind.instrument.Clock;
import org.smallmind.instrument.Clocked;
import org.smallmind.instrument.Estimating;
import org.smallmind.instrument.Histogram;
import org.smallmind.instrument.InstrumentationException;
import org.smallmind.instrument.Meter;
import org.smallmind.instrument.Metered;
import org.smallmind.instrument.Metric;
import org.smallmind.instrument.Samples;
import org.smallmind.instrument.Shutterbug;
import org.smallmind.instrument.Snapshot;
import org.smallmind.instrument.Stoppable;
import org.smallmind.instrument.Timed;

public class Chronometer
implements Metric,
Metered,
Estimating,
Timed,
Shutterbug,
Clocked,
Stoppable {
    private final Histogram histogram;
    private final Meter meter;
    private final TimeUnit durationTimeUnit;

    Chronometer(Samples samples, TimeUnit durationTimeUnit, long tickInterval, TimeUnit tickTimeUnit, Clock clock) {
        this.durationTimeUnit = durationTimeUnit;
        this.meter = new Meter(tickInterval, tickTimeUnit, clock);
        this.histogram = new Histogram(samples);
    }

    public void update(long duration) {
        if (duration < 0L) {
            throw new InstrumentationException("Chronometer durations must be >= 0", new Object[0]);
        }
        this.histogram.update(duration);
        this.meter.mark();
    }

    @Override
    public String getSampleType() {
        return this.histogram.getSampleType();
    }

    @Override
    public Clock getClock() {
        return this.meter.getClock();
    }

    @Override
    public TimeUnit getLatencyTimeUnit() {
        return this.durationTimeUnit;
    }

    @Override
    public TimeUnit getRateTimeUnit() {
        return this.meter.getRateTimeUnit();
    }

    @Override
    public long getCount() {
        return this.meter.getCount();
    }

    @Override
    public double getOneMinuteRate() {
        return this.meter.getOneMinuteRate();
    }

    @Override
    public double getFiveMinuteRate() {
        return this.meter.getFiveMinuteRate();
    }

    @Override
    public double getFifteenMinuteRate() {
        return this.meter.getFifteenMinuteRate();
    }

    @Override
    public double getAverageRate() {
        return this.meter.getAverageRate();
    }

    @Override
    public double getMax() {
        return this.histogram.getMax();
    }

    @Override
    public double getMin() {
        return this.histogram.getMin();
    }

    @Override
    public double getAverage() {
        return this.histogram.getAverage();
    }

    @Override
    public double getStdDev() {
        return this.histogram.getStdDev();
    }

    @Override
    public double getSum() {
        return this.histogram.getSum();
    }

    @Override
    public Snapshot getSnapshot() {
        return new Snapshot(this.histogram.getSnapshot().getValues());
    }

    @Override
    public void stop() {
        this.meter.stop();
    }
}

