/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.instrument;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.smallmind.nutsnbolts.time.TimeUtilities;

public class ExponentiallyWeightedMovingAverage {
    private final AtomicReference<Double> rate = new AtomicReference<Double>(0.0);
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final AtomicLong unprocessed = new AtomicLong();
    private final double alpha;
    private final double intervalInNanos;

    public static ExponentiallyWeightedMovingAverage lastOneMinute(long tickInterval, TimeUnit tickTimeUnit) {
        return new ExponentiallyWeightedMovingAverage(tickInterval, tickTimeUnit, 1);
    }

    public static ExponentiallyWeightedMovingAverage lastFiveMinutes(long tickInterval, TimeUnit tickTimeUnit) {
        return new ExponentiallyWeightedMovingAverage(tickInterval, tickTimeUnit, 5);
    }

    public static ExponentiallyWeightedMovingAverage lastFifteenMinutes(long tickInterval, TimeUnit tickTimeUnit) {
        return new ExponentiallyWeightedMovingAverage(tickInterval, tickTimeUnit, 15);
    }

    private ExponentiallyWeightedMovingAverage(long tickInterval, TimeUnit tickTimeUnit, int minutes) {
        this.alpha = 1.0 - Math.exp(-((double)tickInterval / TimeUtilities.convertToDouble((long)minutes, (TimeUnit)TimeUnit.MINUTES, (TimeUnit)tickTimeUnit)));
        this.intervalInNanos = tickTimeUnit.toNanos(tickInterval);
    }

    public void update(long n) {
        this.unprocessed.addAndGet(n);
    }

    public void tick() {
        if (this.initialized.compareAndSet(false, true)) {
            this.rate.set((double)this.unprocessed.getAndSet(0L) / this.intervalInNanos);
        } else {
            double currentRate = this.rate.get();
            this.rate.set(currentRate + this.alpha * ((double)this.unprocessed.getAndSet(0L) / this.intervalInNanos - currentRate));
        }
    }

    public double getRate(TimeUnit rateTimeUnit) {
        return this.rate.get() * (double)rateTimeUnit.toNanos(1L);
    }
}

