/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.instrument;

import org.smallmind.instrument.Instrument;
import org.smallmind.instrument.InstrumentAndReturn;
import org.smallmind.instrument.InstrumentationArguments;
import org.smallmind.instrument.Metric;
import org.smallmind.instrument.MetricRegistry;
import org.smallmind.nutsnbolts.lang.StaticManager;

public class InstrumentationManager
implements StaticManager {
    private static InheritableThreadLocal<MetricRegistry> METRIC_REGISTRY_LOCAL = new InheritableThreadLocal();

    public static void register(MetricRegistry metricRegistry) {
        METRIC_REGISTRY_LOCAL.set(metricRegistry);
    }

    public static MetricRegistry getMetricRegistry() {
        return (MetricRegistry)METRIC_REGISTRY_LOCAL.get();
    }

    public static <M extends Metric> void execute(Instrument<M> instrument) throws Exception {
        InstrumentationArguments<M> arguments;
        MetricRegistry metricRegistry = (MetricRegistry)METRIC_REGISTRY_LOCAL.get();
        instrument.with(metricRegistry == null || (arguments = instrument.getArguments()) == null ? null : (Object)metricRegistry.instrument(arguments.getBuilder(), arguments.getDomain(), arguments.getProperties()));
    }

    public static <M extends Metric, T> T execute(InstrumentAndReturn<M, T> instrumentAndReturn) throws Exception {
        InstrumentationArguments<M> arguments;
        MetricRegistry metricRegistry = (MetricRegistry)METRIC_REGISTRY_LOCAL.get();
        return instrumentAndReturn.with(metricRegistry == null || (arguments = instrumentAndReturn.getArguments()) == null ? null : (Object)metricRegistry.instrument(arguments.getBuilder(), arguments.getDomain(), arguments.getProperties()));
    }
}

