/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.instrument;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.smallmind.instrument.Clock;
import org.smallmind.instrument.Clocked;
import org.smallmind.instrument.Clocks;
import org.smallmind.instrument.ExponentiallyWeightedMovingAverage;
import org.smallmind.instrument.Metered;
import org.smallmind.instrument.Metric;
import org.smallmind.instrument.Stoppable;
import org.smallmind.nutsnbolts.time.TimeUtilities;

public class Meter
implements Metric,
Metered,
Clocked,
Stoppable {
    private static final ScheduledExecutorService SCHEDULED_EXECUTOR = Executors.newScheduledThreadPool(2, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable);
            thread.setDaemon(true);
            return thread;
        }
    });
    private final AtomicLong count = new AtomicLong(0L);
    private final ExponentiallyWeightedMovingAverage m1Rate;
    private final ExponentiallyWeightedMovingAverage m5Rate;
    private final ExponentiallyWeightedMovingAverage m15Rate;
    private final ScheduledFuture<?> future;
    private final Clock clock;
    private final TimeUnit tickTimeUnit;
    private final long startTime;

    public Meter() {
        this(5L, TimeUnit.SECONDS, Clocks.EPOCH.getClock());
    }

    public Meter(long tickInterval, TimeUnit tickTimeUnit) {
        this(tickInterval, tickTimeUnit, Clocks.EPOCH.getClock());
    }

    Meter(long tickInterval, TimeUnit tickTimeUnit, Clock clock) {
        this.tickTimeUnit = tickTimeUnit;
        this.clock = clock;
        this.startTime = clock.getTimeMilliseconds();
        this.m1Rate = ExponentiallyWeightedMovingAverage.lastOneMinute(tickInterval, tickTimeUnit);
        this.m5Rate = ExponentiallyWeightedMovingAverage.lastFiveMinutes(tickInterval, tickTimeUnit);
        this.m15Rate = ExponentiallyWeightedMovingAverage.lastFifteenMinutes(tickInterval, tickTimeUnit);
        this.future = SCHEDULED_EXECUTOR.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                Meter.this.m1Rate.tick();
                Meter.this.m5Rate.tick();
                Meter.this.m15Rate.tick();
            }
        }, tickInterval, tickInterval, tickTimeUnit);
    }

    public void mark() {
        this.mark(1L);
    }

    public void mark(long n) {
        this.count.addAndGet(n);
        this.m1Rate.update(n);
        this.m5Rate.update(n);
        this.m15Rate.update(n);
    }

    @Override
    public Clock getClock() {
        return this.clock;
    }

    @Override
    public TimeUnit getRateTimeUnit() {
        return this.tickTimeUnit;
    }

    @Override
    public long getCount() {
        return this.count.get();
    }

    @Override
    public double getOneMinuteRate() {
        return this.m1Rate.getRate(this.tickTimeUnit);
    }

    @Override
    public double getFiveMinuteRate() {
        return this.m5Rate.getRate(this.tickTimeUnit);
    }

    @Override
    public double getFifteenMinuteRate() {
        return this.m15Rate.getRate(this.tickTimeUnit);
    }

    @Override
    public double getAverageRate() {
        long currentCount = this.count.get();
        if (currentCount == 0L) {
            return 0.0;
        }
        return (double)currentCount / (double)(this.clock.getTimeMilliseconds() - this.startTime) * TimeUtilities.convertToDouble((long)1L, (TimeUnit)this.tickTimeUnit, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    @Override
    public void stop() {
        this.future.cancel(false);
    }
}

