/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.instrument;

import java.util.concurrent.ConcurrentHashMap;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.smallmind.instrument.Chronometer;
import org.smallmind.instrument.Histogram;
import org.smallmind.instrument.InstrumentationManager;
import org.smallmind.instrument.Meter;
import org.smallmind.instrument.Metric;
import org.smallmind.instrument.MetricKey;
import org.smallmind.instrument.MetricProperty;
import org.smallmind.instrument.Metrics;
import org.smallmind.instrument.Register;
import org.smallmind.instrument.jmx.ChronometerMonitor;
import org.smallmind.instrument.jmx.DefaultJMXNamingPolicy;
import org.smallmind.instrument.jmx.HistogramMonitor;
import org.smallmind.instrument.jmx.JMXNamingPolicy;
import org.smallmind.instrument.jmx.MeterMonitor;
import org.smallmind.instrument.jmx.RegisterMonitor;
import org.smallmind.nutsnbolts.lang.UnknownSwitchCaseException;

public class MetricRegistry {
    private final ConcurrentHashMap<MetricKey, Metric> metricMap = new ConcurrentHashMap();
    private MBeanServer server;
    private JMXNamingPolicy jmxNamingPolicy = new DefaultJMXNamingPolicy();

    public void setServer(MBeanServer server) {
        this.server = server;
    }

    public void setJmxNamingPolicy(JMXNamingPolicy jmxNamingPolicy) {
        this.jmxNamingPolicy = jmxNamingPolicy;
    }

    public void register() {
        InstrumentationManager.register(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <M extends Metric> M instrument(Metrics.MetricBuilder<M> builder, String domain, MetricProperty ... properties) throws MalformedObjectNameException, InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        MetricKey metricKey = new MetricKey(builder.getType(), domain, properties);
        Metric metric = (Metric)builder.getMetricClass().cast(this.metricMap.get(metricKey));
        if (metric == null) {
            ConcurrentHashMap<MetricKey, Metric> concurrentHashMap = this.metricMap;
            synchronized (concurrentHashMap) {
                metric = (Metric)builder.getMetricClass().cast(this.metricMap.get(metricKey));
                if (metric == null) {
                    metric = builder.construct();
                    this.metricMap.put(metricKey, metric);
                    if (this.server != null) {
                        StandardMBean mBean;
                        switch (builder.getType()) {
                            case REGISTER: {
                                mBean = new RegisterMonitor((Register)metric);
                                break;
                            }
                            case METER: {
                                mBean = new MeterMonitor((Meter)metric);
                                break;
                            }
                            case HISTOGRAM: {
                                mBean = new HistogramMonitor((Histogram)metric);
                                break;
                            }
                            case CHRONOMETER: {
                                mBean = new ChronometerMonitor((Chronometer)metric);
                                break;
                            }
                            default: {
                                throw new UnknownSwitchCaseException(builder.getType().name(), new Object[0]);
                            }
                        }
                        this.server.registerMBean(mBean, this.jmxNamingPolicy.createObjectName(builder.getType(), domain, properties));
                    }
                }
            }
        }
        return (M)metric;
    }
}

