/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.instrument;

import java.util.concurrent.TimeUnit;
import org.smallmind.instrument.Chronometer;
import org.smallmind.instrument.Clocks;
import org.smallmind.instrument.Histogram;
import org.smallmind.instrument.Meter;
import org.smallmind.instrument.Metric;
import org.smallmind.instrument.MetricType;
import org.smallmind.instrument.Register;
import org.smallmind.instrument.Samples;

public class Metrics {
    public static MetricBuilder buildRegister(int initialCount) {
        return new RegisterBuilder(initialCount);
    }

    public static MetricBuilder buildMeter(long tickInterval, TimeUnit tickTimeUnit) {
        return new MeterBuilder(tickInterval, tickTimeUnit, Clocks.EPOCH);
    }

    public static MetricBuilder buildMeter(long tickInterval, TimeUnit tickTimeUnit, Clocks clocks) {
        return new MeterBuilder(tickInterval, tickTimeUnit, clocks);
    }

    public static HistogramBuilder buildHistogram(Samples samples) {
        return new HistogramBuilder(samples);
    }

    public static ChronometerBuilder buildChronometer(TimeUnit durationUnit, long tickInterval, TimeUnit tickTimeUnit) {
        return new ChronometerBuilder(Samples.BIASED, durationUnit, tickInterval, tickTimeUnit, Clocks.EPOCH);
    }

    public static ChronometerBuilder buildChronometer(Samples samples, TimeUnit durationUnit, long tickInterval, TimeUnit tickTimeUnit) {
        return new ChronometerBuilder(samples, durationUnit, tickInterval, tickTimeUnit, Clocks.EPOCH);
    }

    public static ChronometerBuilder buildChronometer(TimeUnit durationUnit, long tickInterval, TimeUnit tickTimeUnit, Clocks clocks) {
        return new ChronometerBuilder(Samples.BIASED, durationUnit, tickInterval, tickTimeUnit, clocks);
    }

    public static ChronometerBuilder buildChronometer(Samples samples, TimeUnit durationUnit, long tickInterval, TimeUnit tickTimeUnit, Clocks clocks) {
        return new ChronometerBuilder(samples, durationUnit, tickInterval, tickTimeUnit, clocks);
    }

    private static class ChronometerBuilder
    implements MetricBuilder<Chronometer> {
        private Samples samples;
        private Clocks clocks;
        private TimeUnit durationUnit;
        private TimeUnit tickTimeUnit;
        private long tickInterval;

        private ChronometerBuilder(Samples samples, TimeUnit durationUnit, long tickInterval, TimeUnit tickTimeUnit, Clocks clocks) {
            this.samples = samples;
            this.durationUnit = durationUnit;
            this.tickInterval = tickInterval;
            this.tickTimeUnit = tickTimeUnit;
            this.clocks = clocks;
        }

        @Override
        public Class<Chronometer> getMetricClass() {
            return Chronometer.class;
        }

        @Override
        public MetricType getType() {
            return MetricType.CHRONOMETER;
        }

        @Override
        public Chronometer construct() {
            return new Chronometer(this.samples, this.durationUnit, this.tickInterval, this.tickTimeUnit, this.clocks.getClock());
        }
    }

    private static class HistogramBuilder
    implements MetricBuilder<Histogram> {
        private Samples samples;

        private HistogramBuilder(Samples samples) {
            this.samples = samples;
        }

        @Override
        public Class<Histogram> getMetricClass() {
            return Histogram.class;
        }

        @Override
        public MetricType getType() {
            return MetricType.HISTOGRAM;
        }

        @Override
        public Histogram construct() {
            return new Histogram(this.samples);
        }
    }

    private static class MeterBuilder
    implements MetricBuilder<Meter> {
        private Clocks clocks;
        private TimeUnit tickTimeUnit;
        private long tickInterval;

        private MeterBuilder(long tickInterval, TimeUnit tickTimeUnit, Clocks clocks) {
            this.tickInterval = tickInterval;
            this.tickTimeUnit = tickTimeUnit;
            this.clocks = clocks;
        }

        @Override
        public Class<Meter> getMetricClass() {
            return Meter.class;
        }

        @Override
        public MetricType getType() {
            return MetricType.METER;
        }

        @Override
        public Meter construct() {
            return new Meter(this.tickInterval, this.tickTimeUnit, this.clocks.getClock());
        }
    }

    public static interface MetricBuilder<M extends Metric> {
        public Class<M> getMetricClass();

        public MetricType getType();

        public M construct();
    }

    private static class RegisterBuilder
    implements MetricBuilder<Register> {
        private int initialCount;

        public RegisterBuilder(int initialCount) {
            this.initialCount = initialCount;
        }

        @Override
        public Class<Register> getMetricClass() {
            return Register.class;
        }

        @Override
        public MetricType getType() {
            return MetricType.REGISTER;
        }

        @Override
        public Register construct() {
            return new Register(this.initialCount);
        }
    }
}

