/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.instrument;

import java.util.ArrayList;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.smallmind.instrument.Clock;
import org.smallmind.instrument.Clocks;
import org.smallmind.instrument.Sample;
import org.smallmind.instrument.Samples;
import org.smallmind.instrument.Snapshot;
import org.smallmind.nutsnbolts.util.ThreadLocalRandom;

public class ExponentiallyDecayingSample
implements Sample {
    private static final long RESCALE_THRESHOLD = TimeUnit.HOURS.toMillis(1L);
    private final ReentrantReadWriteLock lock;
    private final ConcurrentSkipListMap<Double, Long> values;
    private final Clock clock;
    private final AtomicLong count = new AtomicLong(0L);
    private final AtomicLong nextScaleTime = new AtomicLong(0L);
    private final AtomicLong startTime;
    private final double alpha;
    private final int reservoirSize;

    public ExponentiallyDecayingSample(int reservoirSize, double alpha) {
        this(reservoirSize, alpha, Clocks.EPOCH.getClock());
    }

    public ExponentiallyDecayingSample(int reservoirSize, double alpha, Clock clock) {
        this.reservoirSize = reservoirSize;
        this.alpha = alpha;
        this.clock = clock;
        this.values = new ConcurrentSkipListMap();
        this.nextScaleTime.set(clock.getTimeMilliseconds() + RESCALE_THRESHOLD);
        this.lock = new ReentrantReadWriteLock();
        this.startTime = new AtomicLong(this.currentTimeInSeconds());
    }

    @Override
    public Samples getType() {
        return Samples.BIASED;
    }

    @Override
    public void clear() {
        this.lock.writeLock().lock();
        try {
            this.values.clear();
            this.count.set(0L);
            this.startTime.set(this.currentTimeInSeconds());
            this.nextScaleTime.set(this.clock.getTimeMilliseconds() + RESCALE_THRESHOLD);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public int size() {
        return (int)Math.min((long)this.reservoirSize, this.count.get());
    }

    @Override
    public void update(long value) {
        this.rescaleIfNeeded();
        this.lock.readLock().lock();
        try {
            double priority = this.weight(this.currentTimeInSeconds() - this.startTime.get()) / ThreadLocalRandom.current().nextDouble();
            long newCount = this.count.incrementAndGet();
            if (newCount <= (long)this.reservoirSize) {
                this.values.put(priority, value);
            } else {
                Double first = this.values.firstKey();
                if (first < priority && this.values.putIfAbsent(priority, value) == null) {
                    while (this.values.remove(first) == null) {
                        first = this.values.firstKey();
                    }
                }
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private void rescaleIfNeeded() {
        long next;
        long now = this.clock.getTimeMilliseconds();
        if (now >= (next = this.nextScaleTime.get())) {
            this.rescale(now, next);
        }
    }

    @Override
    public Snapshot getSnapshot() {
        this.lock.readLock().lock();
        try {
            Snapshot snapshot = new Snapshot(this.values.values());
            return snapshot;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private long currentTimeInSeconds() {
        return TimeUnit.MILLISECONDS.toSeconds(this.clock.getTimeMilliseconds());
    }

    private double weight(long t) {
        return Math.exp(this.alpha * (double)t);
    }

    private void rescale(long now, long next) {
        if (this.nextScaleTime.compareAndSet(next, now + RESCALE_THRESHOLD)) {
            this.lock.writeLock().lock();
            try {
                ArrayList keys = new ArrayList(this.values.keySet());
                long newStartTime = this.currentTimeInSeconds();
                long oldStartTime = this.startTime.getAndSet(newStartTime);
                for (Double key : keys) {
                    Long value = this.values.remove(key);
                    this.values.put(key * Math.exp(-this.alpha * (double)(newStartTime - oldStartTime)), value);
                }
                this.count.set(this.values.size());
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }
}

