/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.instrument;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.smallmind.instrument.Estimating;
import org.smallmind.instrument.Metric;
import org.smallmind.instrument.Sample;
import org.smallmind.instrument.Samples;
import org.smallmind.instrument.Shutterbug;
import org.smallmind.instrument.Snapshot;

public class Histogram
implements Metric,
Estimating,
Shutterbug {
    private final AtomicReference<double[]> variance = new AtomicReference<double[]>(new double[]{-1.0, 0.0});
    private final AtomicLong count = new AtomicLong(0L);
    private final ArrayCache arrayCache = new ArrayCache();
    private final Sample sample;
    private final AtomicLong min = new AtomicLong(Long.MAX_VALUE);
    private final AtomicLong max = new AtomicLong(Long.MIN_VALUE);
    private final AtomicLong sum = new AtomicLong(0L);

    public Histogram(Samples samples) {
        this.sample = samples.createSample();
    }

    @Override
    public void clear() {
        this.sample.clear();
        this.count.set(0L);
        this.max.set(Long.MIN_VALUE);
        this.min.set(Long.MAX_VALUE);
        this.sum.set(0L);
        this.variance.set(new double[]{-1.0, 0.0});
    }

    public void update(long value) {
        this.count.incrementAndGet();
        this.sample.update(value);
        this.setMax(value);
        this.setMin(value);
        this.sum.getAndAdd(value);
        this.updateVariance(value);
    }

    @Override
    public String getSampleType() {
        return this.sample.getType().name();
    }

    @Override
    public long getCount() {
        return this.count.get();
    }

    @Override
    public double getMax() {
        return this.getCount() > 0L ? (double)this.max.get() : 0.0;
    }

    @Override
    public double getMin() {
        return this.getCount() > 0L ? (double)this.min.get() : 0.0;
    }

    @Override
    public double getAverage() {
        return this.getCount() > 0L ? (double)this.sum.get() / (double)this.getCount() : 0.0;
    }

    @Override
    public double getStdDev() {
        return this.getCount() > 0L ? Math.sqrt(this.getVariance()) : 0.0;
    }

    @Override
    public double getSum() {
        return this.sum.get();
    }

    private double getVariance() {
        return this.getCount() <= 1L ? 0.0 : this.variance.get()[1] / (double)(this.getCount() - 1L);
    }

    @Override
    public Snapshot getSnapshot() {
        return this.sample.getSnapshot();
    }

    private void setMax(long potentialMax) {
        boolean done = false;
        while (!done) {
            long currentMax = this.max.get();
            boolean bl = done = currentMax >= potentialMax || this.max.compareAndSet(currentMax, potentialMax);
        }
    }

    private void setMin(long potentialMin) {
        boolean done = false;
        while (!done) {
            long currentMin = this.min.get();
            boolean bl = done = currentMin <= potentialMin || this.min.compareAndSet(currentMin, potentialMin);
        }
    }

    private void updateVariance(long value) {
        boolean done = false;
        while (!done) {
            double[] oldValues = this.variance.get();
            double[] newValues = (double[])this.arrayCache.get();
            if (oldValues[0] == -1.0) {
                newValues[0] = value;
                newValues[1] = 0.0;
            } else {
                double oldM = oldValues[0];
                double oldS = oldValues[1];
                double newM = oldM + ((double)value - oldM) / (double)this.getCount();
                double newS = oldS + ((double)value - oldM) * ((double)value - newM);
                newValues[0] = newM;
                newValues[1] = newS;
            }
            done = this.variance.compareAndSet(oldValues, newValues);
            if (!done) continue;
            this.arrayCache.set(oldValues);
        }
    }

    private static final class ArrayCache
    extends ThreadLocal<double[]> {
        private ArrayCache() {
        }

        @Override
        protected double[] initialValue() {
            return new double[2];
        }
    }
}

