/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.instrument;

import java.util.concurrent.TimeUnit;
import org.smallmind.instrument.Chronometer;
import org.smallmind.instrument.Clocks;
import org.smallmind.instrument.Instrument;
import org.smallmind.instrument.InstrumentAndReturn;
import org.smallmind.instrument.InstrumentationArguments;
import org.smallmind.instrument.Metric;
import org.smallmind.instrument.MetricProperty;
import org.smallmind.instrument.MetricRegistry;
import org.smallmind.instrument.Metrics;
import org.smallmind.instrument.config.MetricConfigurationProvider;
import org.smallmind.nutsnbolts.lang.PerApplicationContext;
import org.smallmind.nutsnbolts.lang.PerApplicationDataManager;

public class InstrumentationManager
implements PerApplicationDataManager {
    public static void register(MetricRegistry metricRegistry) {
        PerApplicationContext.setPerApplicationData(InstrumentationManager.class, (Object)metricRegistry);
    }

    public static MetricRegistry getMetricRegistry() {
        return (MetricRegistry)PerApplicationContext.getPerApplicationData(InstrumentationManager.class, MetricRegistry.class);
    }

    public static <M extends Metric> void execute(Instrument<M> instrument) throws Exception {
        InstrumentationArguments<M> arguments;
        MetricRegistry metricRegistry = InstrumentationManager.getMetricRegistry();
        instrument.with(metricRegistry == null || (arguments = instrument.getArguments()) == null ? null : (Object)metricRegistry.instrument(arguments.getBuilder(), arguments.getDomain(), arguments.getProperties()));
    }

    public static <M extends Metric, T> T execute(InstrumentAndReturn<M, T> instrumentAndReturn) throws Exception {
        InstrumentationArguments<M> arguments;
        MetricRegistry metricRegistry = InstrumentationManager.getMetricRegistry();
        return instrumentAndReturn.with(metricRegistry == null || (arguments = instrumentAndReturn.getArguments()) == null ? null : (Object)metricRegistry.instrument(arguments.getBuilder(), arguments.getDomain(), arguments.getProperties()));
    }

    public static void instrumentWithMeter(MetricConfigurationProvider provider, MetricProperty ... properties) {
        InstrumentationManager.instrumentWithMeter(provider, 1L, properties);
    }

    public static void instrumentWithMeter(MetricConfigurationProvider provider, long quantity, MetricProperty ... properties) {
        if (provider != null && provider.getMetricConfiguration() != null && provider.getMetricConfiguration().isInstrumented()) {
            InstrumentationManager.getMetricRegistry().instrument(Metrics.buildMeter(provider.getMetricConfiguration().getTickInterval(), provider.getMetricConfiguration().getTickTimeUnit(), Clocks.EPOCH), provider.getMetricConfiguration().getMetricDomain().getDomain(), properties).mark(quantity);
        }
    }

    public static void instrumentWithSpeedometer(MetricConfigurationProvider provider, long quantity, MetricProperty ... properties) {
        if (provider != null && provider.getMetricConfiguration() != null && provider.getMetricConfiguration().isInstrumented()) {
            InstrumentationManager.getMetricRegistry().instrument(Metrics.buildSpeedometer(provider.getMetricConfiguration().getTickInterval(), provider.getMetricConfiguration().getTickTimeUnit(), Clocks.EPOCH), provider.getMetricConfiguration().getMetricDomain().getDomain(), properties).update(quantity);
        }
    }

    public static void instrumentWithChronometer(MetricConfigurationProvider provider, long duration, TimeUnit durationTimeUnit, MetricProperty ... properties) {
        if (provider != null && provider.getMetricConfiguration() != null && provider.getMetricConfiguration().isInstrumented()) {
            Chronometer chronometer = InstrumentationManager.getMetricRegistry().instrument(Metrics.buildChronometer(provider.getMetricConfiguration().getSamples(), TimeUnit.MILLISECONDS, provider.getMetricConfiguration().getTickInterval(), provider.getMetricConfiguration().getTickTimeUnit(), Clocks.EPOCH), provider.getMetricConfiguration().getMetricDomain().getDomain(), properties);
            chronometer.update(chronometer.getLatencyTimeUnit().convert(duration, durationTimeUnit));
        }
    }
}

