/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.instrument;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.smallmind.instrument.Clock;
import org.smallmind.instrument.Clocked;
import org.smallmind.instrument.Meter;
import org.smallmind.instrument.Metric;
import org.smallmind.instrument.Stoppable;
import org.smallmind.instrument.Tracked;

public class Speedometer
implements Metric,
Tracked,
Clocked,
Stoppable {
    private final Meter rateMeter;
    private final Meter quantityMeter;
    private final AtomicLong min = new AtomicLong(Long.MAX_VALUE);
    private final AtomicLong max = new AtomicLong(Long.MIN_VALUE);

    public Speedometer(long tickInterval, TimeUnit tickTimeUnit, Clock clock) {
        this.rateMeter = new Meter(tickInterval, tickTimeUnit, clock);
        this.quantityMeter = new Meter(tickInterval, tickTimeUnit, clock);
    }

    @Override
    public void clear() {
        this.rateMeter.clear();
        this.quantityMeter.clear();
        this.min.set(Long.MAX_VALUE);
        this.max.set(Long.MIN_VALUE);
    }

    public void update() {
        this.update(1L);
    }

    public void update(long quantity) {
        this.rateMeter.mark();
        this.quantityMeter.mark(quantity);
        this.setMax(quantity);
        this.setMin(quantity);
    }

    @Override
    public Clock getClock() {
        return this.rateMeter.getClock();
    }

    @Override
    public TimeUnit getRateTimeUnit() {
        return this.rateMeter.getRateTimeUnit();
    }

    @Override
    public long getCount() {
        return this.rateMeter.getCount();
    }

    @Override
    public double getOneMinuteAvgRate() {
        return this.rateMeter.getOneMinuteAvgRate();
    }

    @Override
    public double getOneMinuteAvgVelocity() {
        return this.quantityMeter.getOneMinuteAvgRate() / this.rateMeter.getOneMinuteAvgRate();
    }

    @Override
    public double getFiveMinuteAvgRate() {
        return this.rateMeter.getFiveMinuteAvgRate();
    }

    @Override
    public double getFiveMinuteAvgVelocity() {
        return this.quantityMeter.getFiveMinuteAvgRate() / this.rateMeter.getFiveMinuteAvgRate();
    }

    @Override
    public double getFifteenMinuteAvgRate() {
        return this.rateMeter.getFifteenMinuteAvgRate();
    }

    @Override
    public double getFifteenMinuteAvgVelocity() {
        return this.quantityMeter.getFifteenMinuteAvgRate() / this.rateMeter.getFifteenMinuteAvgRate();
    }

    @Override
    public double getAverageRate() {
        return this.rateMeter.getAverageRate();
    }

    @Override
    public double getAverageVelocity() {
        return this.quantityMeter.getAverageRate() / this.rateMeter.getAverageRate();
    }

    @Override
    public double getMax() {
        return this.getCount() > 0L ? (double)this.max.get() : 0.0;
    }

    private void setMax(long potentialMax) {
        boolean done = false;
        while (!done) {
            long currentMax = this.max.get();
            boolean bl = done = currentMax >= potentialMax || this.max.compareAndSet(currentMax, potentialMax);
        }
    }

    @Override
    public double getMin() {
        return this.getCount() > 0L ? (double)this.min.get() : 0.0;
    }

    private void setMin(long potentialMin) {
        boolean done = false;
        while (!done) {
            long currentMin = this.min.get();
            boolean bl = done = currentMin <= potentialMin || this.min.compareAndSet(currentMin, potentialMin);
        }
    }

    @Override
    public void stop() {
        this.rateMeter.stop();
        this.quantityMeter.stop();
    }
}

