/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.instrument.aop;

import java.util.HashMap;
import java.util.LinkedList;
import org.smallmind.instrument.Metric;
import org.smallmind.instrument.aop.MissingMetricException;

public class MetricSupplier {
    private static final ThreadLocal<HashMap<String, LinkedList<Metric>>> METRIC_MAP_LOCAL = new ThreadLocal<HashMap<String, LinkedList<Metric>>>(){

        @Override
        protected HashMap<String, LinkedList<Metric>> initialValue() {
            return new HashMap<String, LinkedList<Metric>>();
        }
    };

    public static void push(String key, Metric metric) {
        HashMap<String, LinkedList<Metric>> metricMap = METRIC_MAP_LOCAL.get();
        LinkedList<Metric> metricList = metricMap.get(key);
        if (metricList == null) {
            metricList = new LinkedList();
            metricMap.put(key, metricList);
        }
        metricList.push(metric);
    }

    public static void pop(String key) {
        METRIC_MAP_LOCAL.get().get(key).pop();
    }

    public static <M extends Metric> M get(String key, Class<M> metricClass) {
        LinkedList<Metric> metricList = METRIC_MAP_LOCAL.get().get(key);
        if (metricList == null || metricList.isEmpty()) {
            throw new MissingMetricException("The metric(%s) is not locally defined", key == null ? "null" : key);
        }
        return (M)((Metric)metricClass.cast(metricList.peek()));
    }
}

